/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana.dmn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.kie.kogito.grafana.dmn.AbstractDmnType;
import org.kie.kogito.grafana.dmn.BooleanType;
import org.kie.kogito.grafana.dmn.DaysAndTimeDurationType;
import org.kie.kogito.grafana.dmn.LocalDateType;
import org.kie.kogito.grafana.dmn.LocalTimeType;
import org.kie.kogito.grafana.dmn.NumberType;
import org.kie.kogito.grafana.dmn.StringType;
import org.kie.kogito.grafana.dmn.TimeAndDateType;
import org.kie.kogito.grafana.dmn.YearsAndMonthsDurationType;
import org.kie.kogito.grafana.model.functions.GrafanaFunction;
import org.kie.kogito.grafana.model.panel.common.YAxis;

public class SupportedDecisionTypes {
    private static final Set<AbstractDmnType> supportedDmnTypes = new HashSet<AbstractDmnType>();
    private static final Map<Class, String> dmnInternalClassToDmnStandardMap = new HashMap<Class, String>();

    private SupportedDecisionTypes() {
    }

    public static boolean isSupported(String type) {
        return dmnInternalClassToDmnStandardMap.containsValue(type);
    }

    public static boolean isSupported(Class c) {
        return dmnInternalClassToDmnStandardMap.containsKey(c);
    }

    public static String fromInternalToStandard(Class c) {
        return dmnInternalClassToDmnStandardMap.get(c);
    }

    public static Optional<GrafanaFunction> getGrafanaFunction(String dmnType) {
        Optional<AbstractDmnType> type;
        if (SupportedDecisionTypes.isSupported(dmnType) && (type = supportedDmnTypes.stream().filter(x -> x.getDmnType().equalsIgnoreCase(dmnType)).findFirst()).isPresent()) {
            return Optional.ofNullable(type.get().getGrafanaFunction());
        }
        return Optional.empty();
    }

    public static List<YAxis> getYAxis(String dmnType) {
        Optional<AbstractDmnType> type;
        if (SupportedDecisionTypes.isSupported(dmnType) && (type = supportedDmnTypes.stream().filter(x -> x.getDmnType().equalsIgnoreCase(dmnType)).findFirst()).isPresent()) {
            return type.get().getYaxes();
        }
        return new ArrayList<YAxis>();
    }

    public static Collection<String> getSupportedDMNTypes() {
        return dmnInternalClassToDmnStandardMap.values();
    }

    static {
        supportedDmnTypes.add(new BooleanType());
        supportedDmnTypes.add(new NumberType());
        supportedDmnTypes.add(new StringType());
        supportedDmnTypes.add(new TimeAndDateType());
        supportedDmnTypes.add(new DaysAndTimeDurationType());
        supportedDmnTypes.add(new YearsAndMonthsDurationType());
        supportedDmnTypes.add(new LocalDateType());
        supportedDmnTypes.add(new LocalTimeType());
        supportedDmnTypes.stream().forEach(x -> dmnInternalClassToDmnStandardMap.put(x.getInternalClass(), x.getDmnType()));
    }
}

