/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPrintStream
extends PrintStream {
    protected Logger logger;
    private StringBuilder buffer = new StringBuilder();
    protected boolean isError;
    private final PrintStream originalOutputStream;

    public LoggingPrintStream(OutputStream outputStream, boolean isError) {
        super(outputStream);
        this.originalOutputStream = (PrintStream)outputStream;
        this.isError = isError;
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        try {
            this.logger = LoggerFactory.getLogger(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
    }

    protected void log(String s) {
        if (this.isError) {
            this.logger.error(s);
        } else {
            this.logger.info(s);
        }
    }

    @Override
    public void write(int b) {
        this.log(String.valueOf(b));
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        int i;
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        for (i = 0; i < len; ++i) {
            this.writeByte(buf[off + i]);
        }
        for (i = 0; i < len; ++i) {
            this.writeByte(buf[off + i]);
        }
    }

    private void writeByte(byte b) {
        this.buffer.append(Byte.toString(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeString(String s) {
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            this.buffer.append(s);
        }
    }

    private synchronized void newLine() {
        this.log(this.buffer.toString());
        this.buffer.delete(0, this.buffer.length());
    }

    @Override
    public void print(boolean b) {
        this.writeString(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.writeString(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.writeString(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.writeString(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.writeString(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.writeString(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.writeString(String.valueOf(s));
    }

    @Override
    public void print(String s) {
        this.writeString(s == null ? "null" : s);
    }

    @Override
    public void print(Object obj) {
        this.writeString(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(boolean x) {
        Logger logger = this.logger;
        synchronized (logger) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char x) {
        Logger logger = this.logger;
        synchronized (logger) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(int x) {
        Logger logger = this.logger;
        synchronized (logger) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(long x) {
        Logger logger = this.logger;
        synchronized (logger) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(float x) {
        Logger logger = this.logger;
        synchronized (logger) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(double x) {
        Logger logger = this.logger;
        synchronized (logger) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char[] x) {
        Logger logger = this.logger;
        synchronized (logger) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String x) {
        Logger logger = this.logger;
        synchronized (logger) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(Object x) {
        Logger logger = this.logger;
        synchronized (logger) {
            this.print(x);
            this.newLine();
        }
    }

    public static void interceptSysOutSysErr() {
        System.setOut(new LoggingPrintStream(System.out, false));
        System.setErr(new LoggingPrintStream(System.err, true));
    }

    public static void restoreSysOutAndSysErr() {
        System.setOut(((LoggingPrintStream)System.out).originalOutputStream);
        System.setErr(((LoggingPrintStream)System.err).originalOutputStream);
    }
}

