/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.parser.feel11;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.CompositeType;
import org.kie.dmn.feel.lang.Scope;
import org.kie.dmn.feel.lang.SimpleType;
import org.kie.dmn.feel.lang.Symbol;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.lang.types.AliasFEELType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.lang.types.DefaultBuiltinFEELTypeRegistry;
import org.kie.dmn.feel.lang.types.FEELTypeRegistry;
import org.kie.dmn.feel.lang.types.GenListType;
import org.kie.dmn.feel.lang.types.ScopeImpl;
import org.kie.dmn.feel.lang.types.SymbolTable;
import org.kie.dmn.feel.lang.types.VariableSymbol;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.feel.runtime.events.UnknownVariableErrorEvent;
import org.kie.dmn.feel.util.EvalHelper;

public class ParserHelper {
    private FEELEventListenersManager eventsManager;
    private SymbolTable symbols = new SymbolTable();
    private Scope currentScope = this.symbols.getGlobalScope();
    private Stack<String> currentName = new Stack();
    private int dynamicResolution = 0;
    private boolean featDMN12EnhancedForLoopEnabled = true;
    private boolean featDMN12weekday = true;
    private FEELTypeRegistry typeRegistry = DefaultBuiltinFEELTypeRegistry.INSTANCE;

    public ParserHelper() {
        this(null);
    }

    public ParserHelper(FEELEventListenersManager eventsManager) {
        this.eventsManager = eventsManager;
        this.currentName.push("<local>");
    }

    public SymbolTable getSymbolTable() {
        return this.symbols;
    }

    public void pushScope() {
        this.currentScope = new ScopeImpl(this.currentName.peek(), this.currentScope);
    }

    public void pushScope(Type type) {
        this.currentScope = new ScopeImpl(this.currentName.peek(), this.currentScope, type);
    }

    public void setTypeRegistry(FEELTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public void pushTypeScope() {
        this.currentScope = this.typeRegistry.getItemDefScope(this.currentScope);
    }

    public void popScope() {
        this.currentScope = this.currentScope.getParentScope();
    }

    public void pushName(String name) {
        this.currentName.push(name);
    }

    public void pushName(ParserRuleContext ctx) {
        this.currentName.push(this.getName(ctx));
    }

    private String getName(ParserRuleContext ctx) {
        String key = ParserHelper.getOriginalText(ctx);
        if (ctx instanceof FEEL_1_1Parser.KeyStringContext) {
            key = EvalHelper.unescapeString(key);
        }
        return key;
    }

    public void popName() {
        this.currentName.pop();
    }

    public void recoverScope() {
        this.recoverScope(this.currentName.peek());
    }

    public void recoverScope(String name) {
        Scope s = (Scope)this.currentScope.getChildScopes().get(name);
        if (s != null) {
            this.currentScope = s;
            if (this.currentScope.getType() != null && this.currentScope.getType().equals(BuiltInType.UNKNOWN)) {
                this.enableDynamicResolution();
            }
        } else {
            Type scopeType;
            Symbol resolved = this.currentScope.resolve(name);
            Type type = scopeType = resolved != null ? resolved.getType() : null;
            if (scopeType instanceof GenListType) {
                scopeType = ((GenListType)scopeType).getGen();
            }
            if (resolved != null && scopeType instanceof CompositeType) {
                this.pushName(name);
                this.pushScope(scopeType);
                CompositeType type2 = (CompositeType)scopeType;
                for (Map.Entry f : type2.getFields().entrySet()) {
                    this.currentScope.define((Symbol)new VariableSymbol((String)f.getKey(), (Type)f.getValue()));
                }
            } else if (resolved != null && scopeType instanceof SimpleType) {
                BuiltInType resolvedBIType = null;
                if (scopeType instanceof BuiltInType) {
                    resolvedBIType = (BuiltInType)scopeType;
                } else if (scopeType instanceof AliasFEELType) {
                    resolvedBIType = ((AliasFEELType)scopeType).getBuiltInType();
                } else {
                    throw new UnsupportedOperationException("Unsupported BIType " + scopeType + "!");
                }
                this.pushName(name);
                this.pushScope((Type)resolvedBIType);
                switch (resolvedBIType) {
                    case DATE: {
                        this.currentScope.define((Symbol)new VariableSymbol("year", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("month", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("day", (Type)BuiltInType.NUMBER));
                        if (!this.isFeatDMN12weekday()) break;
                        this.currentScope.define((Symbol)new VariableSymbol("weekday", (Type)BuiltInType.NUMBER));
                        break;
                    }
                    case TIME: {
                        this.currentScope.define((Symbol)new VariableSymbol("hour", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("minute", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("second", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("time offset", (Type)BuiltInType.DURATION));
                        this.currentScope.define((Symbol)new VariableSymbol("timezone", (Type)BuiltInType.NUMBER));
                        break;
                    }
                    case DATE_TIME: {
                        this.currentScope.define((Symbol)new VariableSymbol("year", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("month", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("day", (Type)BuiltInType.NUMBER));
                        if (this.isFeatDMN12weekday()) {
                            this.currentScope.define((Symbol)new VariableSymbol("weekday", (Type)BuiltInType.NUMBER));
                        }
                        this.currentScope.define((Symbol)new VariableSymbol("hour", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("minute", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("second", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("time offset", (Type)BuiltInType.DURATION));
                        this.currentScope.define((Symbol)new VariableSymbol("timezone", (Type)BuiltInType.NUMBER));
                        break;
                    }
                    case DURATION: {
                        this.currentScope.define((Symbol)new VariableSymbol("years", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("months", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("days", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("hours", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("minutes", (Type)BuiltInType.NUMBER));
                        this.currentScope.define((Symbol)new VariableSymbol("seconds", (Type)BuiltInType.NUMBER));
                        break;
                    }
                    case RANGE: {
                        this.currentScope.define((Symbol)new VariableSymbol("start included", (Type)BuiltInType.BOOLEAN));
                        this.currentScope.define((Symbol)new VariableSymbol("start", (Type)BuiltInType.UNKNOWN));
                        this.currentScope.define((Symbol)new VariableSymbol("end", (Type)BuiltInType.UNKNOWN));
                        this.currentScope.define((Symbol)new VariableSymbol("end included", (Type)BuiltInType.BOOLEAN));
                        break;
                    }
                    case UNKNOWN: {
                        this.enableDynamicResolution();
                        break;
                    }
                }
            } else {
                this.pushScope();
            }
        }
    }

    public void dismissScope() {
        if (this.currentScope.getType() != null && this.currentScope.getType().equals(BuiltInType.UNKNOWN)) {
            this.disableDynamicResolution();
        }
        this.popScope();
    }

    public void validateVariable(ParserRuleContext ctx, List<String> qn, String name) {
        if (this.eventsManager != null && !this.isDynamicResolution() && this.currentScope.getChildScopes().get(name) == null && this.currentScope.resolve(name) == null) {
            FEELEventListenersManager.notifyListeners((FEELEventListenersManager)this.eventsManager, () -> {
                String varName = qn.stream().collect(Collectors.joining("."));
                return new UnknownVariableErrorEvent(FEELEvent.Severity.ERROR, "Unknown variable '" + varName + "'", ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), (Object)varName);
            });
        }
    }

    public boolean isDynamicResolution() {
        return this.dynamicResolution > 0;
    }

    public void disableDynamicResolution() {
        if (this.dynamicResolution > 0) {
            --this.dynamicResolution;
        }
    }

    public void enableDynamicResolution() {
        ++this.dynamicResolution;
    }

    public void defineVariable(ParserRuleContext ctx) {
        this.defineVariable(this.getName(ctx));
    }

    public void defineVariable(String variable) {
        this.currentScope.define((Symbol)new VariableSymbol(variable));
    }

    public void defineVariable(String variable, Type type) {
        this.currentScope.define((Symbol)new VariableSymbol(variable, type));
    }

    public void startVariable(Token t) {
        this.currentScope.start(t.getText());
    }

    public boolean followUp(Token t, boolean isPredict) {
        boolean follow;
        boolean dynamicResolutionResult = this.isDynamicResolution() && FEELParser.isVariableNamePartValid(t.getText(), this.currentScope);
        boolean bl = follow = dynamicResolutionResult || this.currentScope.followUp(t.getText(), isPredict);
        if (dynamicResolutionResult && !isPredict) {
            this.currentScope.followUp(t.getText(), isPredict);
        }
        return follow;
    }

    public static String getOriginalText(ParserRuleContext ctx) {
        int a = ctx.start.getStartIndex();
        int b = ctx.stop.getStopIndex();
        Interval interval = new Interval(a, b);
        return ctx.getStart().getInputStream().getText(interval);
    }

    public int fphStart(ParserRuleContext ctx, Parser parser) {
        boolean ctxSquared;
        if (!(ctx instanceof FEEL_1_1Parser.FilterPathExpressionContext)) {
            return 0;
        }
        FEEL_1_1Parser.FilterPathExpressionContext ctx0 = (FEEL_1_1Parser.FilterPathExpressionContext)ctx;
        boolean bl = ctxSquared = ctx0.filter != null && ctx0.n0 != null;
        if (!ctxSquared) {
            return 0;
        }
        ParserRuleContext ctx1 = ctx0.n0.getRuleContext(FEEL_1_1Parser.NonSignedUnaryExpressionContext.class, 0);
        if (ctx1 == null) {
            return 0;
        }
        ParserRuleContext ctx2 = ctx1.getRuleContext(FEEL_1_1Parser.UenpmPrimaryContext.class, 0);
        if (ctx2 == null) {
            return 0;
        }
        ParserRuleContext ctx3 = ctx2.getRuleContext(FEEL_1_1Parser.PrimaryNameContext.class, 0);
        if (ctx3 == null) {
            return 0;
        }
        FEEL_1_1Parser.QualifiedNameContext ctx4 = (FEEL_1_1Parser.QualifiedNameContext)ctx3.getRuleContext(FEEL_1_1Parser.QualifiedNameContext.class, 0);
        if (ctx4 == null) {
            return 0;
        }
        for (String n : ctx4.qns) {
            this.recoverScope(n);
        }
        return ctx4.qns.size();
    }

    public void fphEnd(int times) {
        for (int i = 0; i < times; ++i) {
            this.dismissScope();
        }
    }

    public static List<Token> getAllTokens(ParseTree ctx, List<Token> tokens) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof TerminalNode) {
                tokens.add(((TerminalNode)child).getSymbol());
                continue;
            }
            ParserHelper.getAllTokens(child, tokens);
        }
        return tokens;
    }

    public boolean isFeatDMN12EnhancedForLoopEnabled() {
        return this.featDMN12EnhancedForLoopEnabled;
    }

    public void setFeatDMN12EnhancedForLoopEnabled(boolean featDMN12EnhancedForLoopEnabled) {
        this.featDMN12EnhancedForLoopEnabled = featDMN12EnhancedForLoopEnabled;
    }

    public boolean isFeatDMN12weekday() {
        return this.featDMN12weekday;
    }

    public void setFeatDMN12weekday(boolean featDMN12weekday) {
        this.featDMN12weekday = featDMN12weekday;
    }
}

