/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.marshaller;

import java.math.BigDecimal;
import java.time.LocalDate;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.marshaller.FEELMarshaller;
import org.kie.dmn.feel.runtime.functions.DateFunction;

public class FEELStringMarshaller
implements FEELMarshaller<String> {
    public static final FEELStringMarshaller INSTANCE = new FEELStringMarshaller();

    private FEELStringMarshaller() {
    }

    public String marshall(Object value) {
        if (value == null) {
            return "null";
        }
        return value.toString();
    }

    public Object unmarshall(Type feelType, String value) {
        if ("null".equals(value)) {
            return null;
        }
        if (feelType.equals(BuiltInType.NUMBER)) {
            return new BigDecimal(value);
        }
        if (feelType.equals(BuiltInType.STRING)) {
            return value;
        }
        if (feelType.equals(BuiltInType.DATE)) {
            return LocalDate.from(DateFunction.FEEL_DATE.parse(value));
        }
        if (feelType.equals(BuiltInType.TIME)) {
            return null;
        }
        if (feelType.equals(BuiltInType.DATE_TIME)) {
            return null;
        }
        if (feelType.equals(BuiltInType.DURATION)) {
            return null;
        }
        if (feelType.equals(BuiltInType.BOOLEAN)) {
            return Boolean.parseBoolean(value);
        }
        if (feelType.equals(BuiltInType.RANGE) || feelType.equals(BuiltInType.FUNCTION) || feelType.equals(BuiltInType.LIST) || feelType.equals(BuiltInType.CONTEXT) || feelType.equals(BuiltInType.UNARY_TEST)) {
            throw new UnsupportedOperationException("FEELStringMarshaller is unable to unmarshall complex types like: " + feelType.getName());
        }
        return null;
    }
}

