/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.FormalParameterNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.ast.Visitor;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.functions.CustomFEELFunction;
import org.kie.dmn.feel.util.Msg;

public class FunctionDefNode
extends BaseNode {
    private static final String ANONYMOUS = "<anonymous>";
    private static final RegExp METHOD_PARSER = RegExp.compile((String)"(.+)\\((.*)\\)");
    private static final RegExp PARAMETER_PARSER = RegExp.compile((String)"([^, ]+)");
    private List<FormalParameterNode> formalParameters = new ArrayList<FormalParameterNode>();
    private boolean external;
    private BaseNode body;

    public FunctionDefNode(ParserRuleContext ctx, ListNode formalParameters, boolean external, BaseNode body) {
        super(ctx);
        this.external = external;
        this.body = body;
        if (formalParameters != null) {
            for (BaseNode name : formalParameters.getElements()) {
                this.formalParameters.add((FormalParameterNode)name);
            }
        }
    }

    public List<FormalParameterNode> getFormalParameters() {
        return this.formalParameters;
    }

    public void setFormalParameters(List<FormalParameterNode> formalParameters) {
        this.formalParameters = formalParameters;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public BaseNode getBody() {
        return this.body;
    }

    public void setBody(BaseNode body) {
        this.body = body;
    }

    public Object evaluate(EvaluationContext ctx) {
        List params = this.formalParameters.stream().map(p -> p.evaluate(ctx)).collect(Collectors.toList());
        if (this.external) {
            try {
                Map conf = (Map)this.body.evaluate(ctx);
                Map java = (Map)conf.get("java");
                if (java != null) {
                    String clazzName = (String)java.get("class");
                    String methodSignature = (String)java.get("method signature");
                    if (clazzName != null && methodSignature != null) {
                        ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.PARAMETER_COUNT_MISMATCH_ON_FUNCTION_DEFINITION, this.getText())));
                        return null;
                    }
                }
                ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.UNABLE_TO_FIND_EXTERNAL_FUNCTION_AS_DEFINED_BY, this.getText())));
            }
            catch (Exception e) {
                ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.ERROR_RESOLVING_EXTERNAL_FUNCTION_AS_DEFINED_BY, this.getText()), e));
            }
            return null;
        }
        return new CustomFEELFunction(ANONYMOUS, params, this.body, ctx.current());
    }

    public static String[] parseMethod(String signature) {
        MatchResult m = METHOD_PARSER.exec(signature);
        if (m != null) {
            String[] result = new String[]{m.getGroup(1), m.getGroup(2)};
            return result;
        }
        return null;
    }

    public static String[] parseParams(String params) {
        MatchResult m;
        ArrayList<String> ps = new ArrayList<String>();
        if (params.trim().length() > 0 && (m = PARAMETER_PARSER.exec(params.trim())) != null) {
            for (int i = 0; i < m.getGroupCount(); ++i) {
                ps.add(m.getGroup(i).trim());
            }
        }
        return ps.toArray(new String[ps.size()]);
    }

    private static Class<?> convertPrimitiveNameToType(String typeName) {
        if (typeName.equals("int")) {
            return Integer.TYPE;
        }
        if (typeName.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (typeName.equals("char")) {
            return Character.TYPE;
        }
        if (typeName.equals("byte")) {
            return Byte.TYPE;
        }
        if (typeName.equals("short")) {
            return Short.TYPE;
        }
        if (typeName.equals("float")) {
            return Float.TYPE;
        }
        if (typeName.equals("long")) {
            return Long.TYPE;
        }
        if (typeName.equals("double")) {
            return Double.TYPE;
        }
        return null;
    }

    public Type getResultType() {
        return BuiltInType.FUNCTION;
    }

    public ASTNode[] getChildrenNode() {
        ASTNode[] children = new ASTNode[this.formalParameters.size() + 1];
        System.arraycopy(this.formalParameters.toArray(new ASTNode[0]), 0, children, 0, this.formalParameters.size());
        children[children.length - 1] = this.body;
        return children;
    }

    public <T> T accept(Visitor<T> v) {
        return (T)v.visit(this);
    }
}

