/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner.management;

import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.kie.scanner.management.KieScannerMBean;
import org.kie.scanner.management.MBeanUtils;

public class KieScannerMBeanImpl
implements KieScannerMBean {
    private static final String MBEAN_NAME = "org.kie:type=scanner,id=%s,c=%d";
    private static final AtomicInteger counter = new AtomicInteger(0);
    private ObjectName mbeanName;
    private InternalKieScanner scanner;

    public KieScannerMBeanImpl(InternalKieScanner scanner) {
        this.scanner = scanner;
        String name = String.format(MBEAN_NAME, ObjectName.quote(scanner.getScannerReleaseId().toExternalForm()), counter.incrementAndGet());
        this.mbeanName = MBeanUtils.createObjectName(name);
        MBeanUtils.registerMBean(this, KieScannerMBean.class, this.mbeanName);
    }

    public ObjectName getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public String getScannerReleaseId() {
        return this.scanner.getScannerReleaseId().toExternalForm();
    }

    @Override
    public String getCurrentReleaseId() {
        return this.scanner.getCurrentReleaseId().toExternalForm();
    }

    @Override
    public String getStatus() {
        return this.scanner.getStatus().toString();
    }

    @Override
    public void scanNow() {
        this.scanner.scanNow();
    }

    @Override
    public void start(long pollingInterval) {
        this.scanner.start(pollingInterval);
    }

    @Override
    public void stop() {
        this.scanner.stop();
    }

    @Override
    public void shutdown() {
        this.scanner.shutdown();
    }
}

