/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Qualifier;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.eclipse.sisu.space.AbstractSisuIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SisuIndexAPT6
extends AbstractSisuIndex
implements Processor {
    private static final String QUALIFIERS = "qualifiers";
    private static final String ALL = "all";
    private static final String NONE = "none";
    private ProcessingEnvironment environment;
    private String qualifiers;

    @Override
    public void init(ProcessingEnvironment _environment) {
        this.environment = _environment;
        this.qualifiers = _environment.getOptions().get(QUALIFIERS);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        Elements elementUtils = this.environment.getElementUtils();
        for (TypeElement typeElement : annotations) {
            if (typeElement.getAnnotation(Qualifier.class) == null) continue;
            for (Element element : round.getElementsAnnotatedWith(typeElement)) {
                if (!element.getKind().isClass()) continue;
                this.addClassToIndex(NAMED, elementUtils.getBinaryName((TypeElement)element));
            }
        }
        if (round.processingOver()) {
            this.flushIndex();
        }
        return false;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        if (ALL.equalsIgnoreCase(this.qualifiers)) {
            return Collections.singleton("*");
        }
        if (NONE.equalsIgnoreCase(this.qualifiers)) {
            return Collections.emptySet();
        }
        return Collections.singleton(NAMED);
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.singleton(QUALIFIERS);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_6;
    }

    @Override
    protected void info(String msg) {
        this.environment.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
    }

    @Override
    protected void warn(String msg) {
        this.environment.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
    }

    @Override
    protected Reader getReader(String path) throws IOException {
        FileObject file = this.environment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", path);
        return new InputStreamReader(file.openInputStream(), "UTF-8");
    }

    @Override
    protected Writer getWriter(String path) throws IOException {
        return this.environment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", path, new Element[0]).openWriter();
    }
}

