/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.common.util.Base64Url;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.WebAuthnCredentialModel;

public class WebAuthnAuthenticatorsBean {
    private List<WebAuthnAuthenticatorBean> authenticators = new LinkedList<WebAuthnAuthenticatorBean>();

    public WebAuthnAuthenticatorsBean(KeycloakSession session, RealmModel realm, UserModel user, String credentialType) {
        this.authenticators = session.userCredentialManager().getStoredCredentialsByTypeStream(realm, user, credentialType).map(WebAuthnCredentialModel::createFromCredentialModel).map(webAuthnCredential -> {
            String credentialId = Base64Url.encodeBase64ToBase64Url((String)webAuthnCredential.getWebAuthnCredentialData().getCredentialId());
            String label = webAuthnCredential.getUserLabel() == null || webAuthnCredential.getUserLabel().isEmpty() ? "label missing" : webAuthnCredential.getUserLabel();
            return new WebAuthnAuthenticatorBean(credentialId, label);
        }).collect(Collectors.toList());
    }

    public List<WebAuthnAuthenticatorBean> getAuthenticators() {
        return this.authenticators;
    }

    public static class WebAuthnAuthenticatorBean {
        private final String credentialId;
        private final String label;

        public WebAuthnAuthenticatorBean(String credentialId, String label) {
            this.credentialId = credentialId;
            this.label = label;
        }

        public String getCredentialId() {
            return this.credentialId;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

