/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.util.Objects;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstantiationAwareExtension;
import org.junit.jupiter.params.ArgumentSetLifecycleMethod;
import org.junit.jupiter.params.EvaluatedArgumentSet;
import org.junit.jupiter.params.ParameterizedClassContext;
import org.junit.jupiter.params.ResolutionCache;

abstract class AbstractParameterizedClassInvocationLifecycleMethodInvoker
implements ParameterResolver {
    private final ParameterizedClassContext declarationContext;
    private final EvaluatedArgumentSet arguments;
    private final int invocationIndex;
    private final ResolutionCache resolutionCache;
    private final ArgumentSetLifecycleMethod lifecycleMethod;

    AbstractParameterizedClassInvocationLifecycleMethodInvoker(ParameterizedClassContext declarationContext, EvaluatedArgumentSet arguments, int invocationIndex, ResolutionCache resolutionCache, ArgumentSetLifecycleMethod lifecycleMethod) {
        this.declarationContext = declarationContext;
        this.arguments = arguments;
        this.invocationIndex = invocationIndex;
        this.resolutionCache = resolutionCache;
        this.lifecycleMethod = lifecycleMethod;
    }

    public TestInstantiationAwareExtension.ExtensionContextScope getTestInstantiationExtensionContextScope(ExtensionContext rootContext) {
        return TestInstantiationAwareExtension.ExtensionContextScope.TEST_METHOD;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getDeclaringExecutable().equals(this.lifecycleMethod.method) && this.lifecycleMethod.parameterResolver.supports(parameterContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Objects.requireNonNull(this.lifecycleMethod.parameterResolver.resolve(parameterContext, extensionContext, this.arguments, this.invocationIndex, this.resolutionCache));
    }

    protected void invoke(ExtensionContext context) {
        if (this.isCorrectTestClass(context)) {
            ExecutableInvoker executableInvoker = context.getExecutableInvoker();
            Object testInstance = context.getTestInstance().orElse(null);
            executableInvoker.invoke(this.lifecycleMethod.method, testInstance);
        }
    }

    private boolean isCorrectTestClass(ExtensionContext context) {
        return this.declarationContext.getAnnotatedElement().equals(context.getTestClass().orElse(null));
    }
}

