/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.support.filter;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.Filter;
import org.junit.gen5.engine.FilterResult;

@API(value=API.Usage.Internal)
public class ExclusionReasonConsumingFilter<T>
implements Filter<T> {
    private final Filter<T> filter;
    private final BiConsumer<T, Optional<String>> reasonConsumer;

    public ExclusionReasonConsumingFilter(Filter<T> filter, BiConsumer<T, Optional<String>> reasonConsumer) {
        this.filter = filter;
        this.reasonConsumer = reasonConsumer;
    }

    @Override
    public FilterResult filter(T object) {
        FilterResult result = this.filter.filter(object);
        if (result.excluded()) {
            this.reasonConsumer.accept(object, result.getReason());
        }
        return result;
    }
}

