/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine;

import java.util.Collection;
import java.util.stream.Collectors;
import org.junit.gen5.engine.DiscoveryFilter;
import org.junit.gen5.engine.FilterResult;

class CombinedDiscoveryFilter<T>
implements DiscoveryFilter<T> {
    private static final DiscoveryFilter ALWAYS_INCLUDED_DISCOVERY_FILTER = obj -> FilterResult.included("Always included");
    private final Collection<? extends DiscoveryFilter<T>> filters;

    static <T> DiscoveryFilter<T> alwaysIncluded() {
        return ALWAYS_INCLUDED_DISCOVERY_FILTER;
    }

    public CombinedDiscoveryFilter(Collection<? extends DiscoveryFilter<T>> filters) {
        this.filters = filters;
    }

    @Override
    public FilterResult filter(T element) {
        return this.filters.stream().map(filter -> filter.filter(element)).filter(FilterResult::excluded).findFirst().orElse(FilterResult.included("Element was included by all filters."));
    }

    public String toString() {
        return this.filters.stream().map(Object::toString).map(value -> String.format("(%s)", value)).collect(Collectors.joining(" and "));
    }
}

