/*
 * Licensed to JumpMind Inc under one or more contributor 
 * license agreements.  See the NOTICE file distributed
 * with this work for additional information regarding 
 * copyright ownership.  JumpMind Inc licenses this file
 * to you under the GNU Lesser General Public License (the
 * "License"); you may not use this file except in compliance
 * with the License. 
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see           
 * <http://www.gnu.org/licenses/>.
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License. 
 */
package org.jumpmind.symmetric.io.data;

final public class CsvConstants {

    private CsvConstants() {
    }
    
    public static final String NO_BINARY_OLD_DATA = "no_binary_old_data";
    
    public static final String BINARY = "binary";

    public static final String NODEID = "nodeid";

    public static final String SCHEMA = "schema";
    
    public static final String CATALOG = "catalog";
    
    public static final String TABLE = "table";

    public static final String KEYS = "keys";

    public static final String COLUMNS = "columns";

    public static final String BATCH = "batch";

    public static final String INSERT = "insert";

    public static final String UPDATE = "update";

    public static final String OLD = "old";

    public static final String DELETE = "delete";

    public static final String COMMIT = "commit";

    public static final String SQL = "sql";
    
    public static final String BSH = "bsh";

    public static final String CREATE = "create";

    public static final String CHANNEL = "channel";
    
    public static final String IGNORE = "ignore";
}
