/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.util.List;
import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.SmiDefaultValue;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiNamedNumber;
import org.jsmiparser.smi.SmiObjectType;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiPrimitiveType;
import org.jsmiparser.smi.SmiRange;
import org.jsmiparser.smi.SmiRow;
import org.jsmiparser.smi.SmiTable;
import org.jsmiparser.smi.SmiTextualConvention;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.util.token.IdToken;
import org.jsmiparser.util.token.QuotedStringToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmiVariable
extends SmiObjectType {
    private final QuotedStringToken m_unitsToken;
    private final SmiDefaultValue m_defaultValue;

    public SmiVariable(IdToken idToken, SmiModule module, SmiType type, QuotedStringToken unitsToken, SmiDefaultValue defaultValue) {
        super(idToken, module);
        this.setType(type);
        this.m_unitsToken = unitsToken;
        this.m_defaultValue = defaultValue;
        if (this.m_defaultValue != null) {
            this.m_defaultValue.m_variable = this;
        }
    }

    public String getCodeConstantId() {
        return this.getModule().getMib().getCodeNamingStrategy().getCodeConstantId(this);
    }

    public String getFullCodeConstantId() {
        return this.getModule().getMib().getCodeNamingStrategy().getFullCodeConstantId(this);
    }

    public String getCodeOid() {
        return this.getOidStr();
    }

    public String getRequestMethodId() {
        return this.getModule().getMib().getCodeNamingStrategy().getRequestMethodId(this);
    }

    public String getGetterMethodId() {
        return this.getModule().getMib().getCodeNamingStrategy().getGetterMethodId(this);
    }

    public String getSetterMethodId() {
        return this.getModule().getMib().getCodeNamingStrategy().getSetterMethodId(this);
    }

    public SmiRow getRow() {
        SmiOidValue oidValue;
        if (this.getNode() != null && this.getNode().getParent() != null && (oidValue = this.getNode().getParent().getSingleValue(SmiOidValue.class, this.getModule())) instanceof SmiRow) {
            return (SmiRow)oidValue;
        }
        return null;
    }

    public SmiTable getTable() {
        SmiRow row = this.getRow();
        if (row != null) {
            return row.getTable();
        }
        return null;
    }

    public boolean isColumn() {
        return this.getRow() != null;
    }

    public boolean isScalar() {
        return this.getRow() == null;
    }

    public String getUnits() {
        return this.m_unitsToken != null ? (String)this.m_unitsToken.getValue() : null;
    }

    public QuotedStringToken getUnitsToken() {
        return this.m_unitsToken;
    }

    public SmiTextualConvention getTextualConvention() {
        for (SmiType type = this.m_type; type != null; type = type.getBaseType()) {
            if (!(type instanceof SmiTextualConvention)) continue;
            return (SmiTextualConvention)type;
        }
        return null;
    }

    public SmiPrimitiveType getPrimitiveType() {
        return this.m_type.getPrimitiveType();
    }

    public SmiType getEnumType() {
        for (SmiType type = this.m_type; type != null; type = type.getBaseType()) {
            if (type.getEnumValues() == null) continue;
            return type;
        }
        return null;
    }

    public List<SmiNamedNumber> getEnumValues() {
        SmiType type = this.getEnumType();
        if (type != null) {
            return type.getEnumValues();
        }
        return null;
    }

    public SmiType getBitFieldType() {
        for (SmiType type = this.m_type; type != null; type = type.getBaseType()) {
            if (type.getBitFields() == null) continue;
            return type;
        }
        return null;
    }

    public List<SmiNamedNumber> getBitFields() {
        SmiType type = this.getBitFieldType();
        if (type != null) {
            return type.getBitFields();
        }
        return null;
    }

    public SmiType getRangeConstraintType() {
        for (SmiType type = this.m_type; type != null; type = type.getBaseType()) {
            if (type.getRangeConstraints() == null) continue;
            return type;
        }
        return null;
    }

    public List<SmiRange> getRangeConstraints() {
        SmiType type = this.getRangeConstraintType();
        if (type != null) {
            return type.getRangeConstraints();
        }
        return null;
    }

    public SmiType getSizeConstraintType() {
        for (SmiType type = this.m_type; type != null; type = type.getBaseType()) {
            if (type.getSizeConstraints() == null) continue;
            return type;
        }
        return null;
    }

    public SmiType getSizeConstraints() {
        SmiType type = this.getSizeConstraintType();
        if (type != null) {
            return type;
        }
        return null;
    }

    public SmiDefaultValue getDefaultValue() {
        return this.m_defaultValue;
    }

    public SmiNamedNumber resolveBitField(IdToken idToken, XRefProblemReporter reporter) {
        for (SmiNamedNumber nn : this.getBitFields()) {
            if (!nn.getId().equals(idToken.getId())) continue;
            return nn;
        }
        reporter.reportCannotFindBitField(idToken);
        return null;
    }

    public SmiNamedNumber resolveEnumConstant(IdToken idToken, XRefProblemReporter reporter) {
        for (SmiNamedNumber nn : this.getEnumValues()) {
            if (!nn.getId().equals(idToken.getId())) continue;
            return nn;
        }
        reporter.reportCannotFindEnumConstant(idToken);
        return null;
    }
}

