/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.util.ArrayList;
import java.util.List;
import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.SmiField;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiNamedNumber;
import org.jsmiparser.smi.SmiPrimitiveType;
import org.jsmiparser.smi.SmiRange;
import org.jsmiparser.smi.SmiReferencedType;
import org.jsmiparser.smi.SmiSymbol;
import org.jsmiparser.smi.SmiVarBindField;
import org.jsmiparser.util.token.IdToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmiType
extends SmiSymbol {
    public static final SmiPrimitiveType[] APPLICATION_TYPES = new SmiPrimitiveType[]{SmiPrimitiveType.IP_ADDRESS, SmiPrimitiveType.COUNTER_32, SmiPrimitiveType.GAUGE_32, SmiPrimitiveType.TIME_TICKS, SmiPrimitiveType.OPAQUE, null, SmiPrimitiveType.COUNTER_64};
    private SmiType m_baseType;
    private final SmiPrimitiveType m_primitiveType;
    private List<SmiNamedNumber> m_enumValues;
    private List<SmiNamedNumber> m_bitFields;
    private List<SmiRange> m_rangeConstraints;
    private List<SmiRange> m_sizeConstraints;
    private List<SmiField> m_fields;
    private IdToken m_elementTypeToken;
    private SmiType m_elementType;

    public SmiType(IdToken idToken, SmiModule module, SmiPrimitiveType primitiveType) {
        super(idToken, module);
        this.m_primitiveType = primitiveType;
    }

    public SmiType(IdToken idToken, SmiModule module, int applicationTag) {
        super(idToken, module);
        if (applicationTag >= 0) {
            if (applicationTag >= APPLICATION_TYPES.length) {
                throw new IllegalArgumentException("Application tag " + applicationTag + " is invalid at: " + idToken);
            }
            this.m_primitiveType = APPLICATION_TYPES[applicationTag] == SmiPrimitiveType.GAUGE_32 && "Unsigned32".equals(this.getId()) ? SmiPrimitiveType.UNSIGNED_32 : APPLICATION_TYPES[applicationTag];
        } else {
            this.m_primitiveType = null;
        }
    }

    public SmiType(IdToken idToken, SmiModule module) {
        super(idToken, module);
        this.m_primitiveType = null;
    }

    public SmiType getBaseType() {
        return this.m_baseType;
    }

    public void setBaseType(SmiType baseType) {
        this.m_baseType = baseType;
    }

    public SmiPrimitiveType getPrimitiveType() {
        if (this.m_enumValues != null) {
            return SmiPrimitiveType.ENUM;
        }
        if (this.m_bitFields != null) {
            return SmiPrimitiveType.BITS;
        }
        if ("Integer32".equals(this.getId()) && "SNMPv2-SMI".equals(this.getModule().getId())) {
            return SmiPrimitiveType.INTEGER_32;
        }
        if (this.m_primitiveType == null && this.m_baseType != null) {
            return this.m_baseType.getPrimitiveType();
        }
        return this.m_primitiveType;
    }

    public SmiVarBindField getVarBindField() {
        return this.getPrimitiveType().getVarBindField();
    }

    public List<SmiNamedNumber> getEnumValues() {
        return this.m_enumValues;
    }

    public void setEnumValues(List<SmiNamedNumber> enumValues) {
        if (enumValues != null) {
            this.setType(enumValues);
        }
        this.m_enumValues = enumValues;
    }

    private void setType(List<SmiNamedNumber> enumValues) {
        for (SmiNamedNumber namedNumber : enumValues) {
            namedNumber.setType(this);
        }
    }

    public List<SmiNamedNumber> getBitFields() {
        return this.m_bitFields;
    }

    public void setBitFields(List<SmiNamedNumber> bitFields) {
        if (bitFields != null) {
            this.setType(bitFields);
        }
        this.m_bitFields = bitFields;
    }

    public List<SmiNamedNumber> getNamedNumbers() {
        if (this.m_enumValues != null) {
            return this.m_enumValues;
        }
        if (this.m_bitFields != null) {
            return this.m_bitFields;
        }
        return null;
    }

    @Override
    public String getCodeId() {
        return this.getModule().getMib().getCodeNamingStrategy().getTypeId(this);
    }

    public SmiNamedNumber getBiggestEnumValue() {
        int currentBiggest = Integer.MIN_VALUE;
        SmiNamedNumber result = null;
        for (SmiNamedNumber ev : this.m_enumValues) {
            if (ev.getValue().intValue() <= currentBiggest) continue;
            currentBiggest = ev.getValue().intValue();
            result = ev;
        }
        return result;
    }

    public SmiNamedNumber getSmallestEnumValue() {
        int currentSmallest = Integer.MAX_VALUE;
        SmiNamedNumber result = null;
        for (SmiNamedNumber ev : this.m_enumValues) {
            if (ev.getValue().intValue() >= currentSmallest) continue;
            currentSmallest = ev.getValue().intValue();
            result = ev;
        }
        return result;
    }

    public SmiNamedNumber findEnumValue(int i) {
        for (SmiNamedNumber ev : this.m_enumValues) {
            if (ev.getValue().intValue() != i) continue;
            return ev;
        }
        return null;
    }

    public SmiNamedNumber findEnumValue(String id) {
        for (SmiNamedNumber ev : this.m_enumValues) {
            if (!ev.getId().equals(id)) continue;
            return ev;
        }
        return null;
    }

    public List<SmiRange> getRangeConstraints() {
        return this.m_rangeConstraints;
    }

    public void setRangeConstraints(List<SmiRange> rangeConstraints) {
        this.m_rangeConstraints = rangeConstraints;
    }

    public List<SmiRange> getSizeConstraints() {
        return this.m_sizeConstraints;
    }

    public void setSizeConstraints(List<SmiRange> sizeConstraints) {
        this.m_sizeConstraints = sizeConstraints;
    }

    public void addField(IdToken col, SmiType fieldType) {
        if (this.m_fields == null) {
            this.m_fields = new ArrayList<SmiField>();
        }
        this.m_fields.add(new SmiField(this, col, fieldType));
    }

    public List<SmiField> getFields() {
        return this.m_fields;
    }

    public IdToken getElementTypeToken() {
        return this.m_elementTypeToken;
    }

    public void setElementTypeToken(IdToken elementTypeToken) {
        this.m_elementTypeToken = elementTypeToken;
    }

    public SmiType getElementType() {
        return this.m_elementType;
    }

    public void setElementType(SmiType elementType) {
        this.m_elementType = elementType;
    }

    public SmiType resolveThis(XRefProblemReporter reporter, SmiType ignored) {
        if (this.m_baseType != null) {
            this.m_baseType = this.m_baseType.resolveThis(reporter, this);
        }
        return this;
    }

    @Override
    public void resolveReferences(XRefProblemReporter reporter) {
        assert (this.getIdToken() != null);
        assert (!(this instanceof SmiReferencedType));
        if (this.m_baseType != null) {
            this.m_baseType = this.m_baseType.resolveThis(reporter, this);
        }
        if (this.m_elementTypeToken != null) {
            this.m_elementType = this.getModule().resolveReference(this.m_elementTypeToken, SmiType.class, reporter);
        }
        if (this.m_fields != null) {
            for (SmiField field : this.m_fields) {
                field.resolveReferences(reporter);
            }
        }
    }
}

