/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.Notification;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiValue;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.util.token.IdToken;
import org.jsmiparser.util.token.IntegerToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmiTrapType
extends SmiValue
implements Notification {
    private IdToken m_enterpriseIdToken;
    private SmiOidValue m_enterpriseOid;
    private List<IdToken> m_variableTokens;
    private List<SmiVariable> m_variables = new ArrayList<SmiVariable>();
    private String m_description;
    private String m_reference;
    private IntegerToken m_specificTypeToken;

    public SmiTrapType(IdToken idToken, SmiModule module, IdToken enterpriseIdToken, List<IdToken> variableTokens, String description, String reference) {
        super(idToken, module);
        this.m_enterpriseIdToken = enterpriseIdToken;
        this.m_variableTokens = variableTokens;
        if (this.m_variableTokens == null) {
            this.m_variableTokens = Collections.emptyList();
        }
        this.m_description = description;
        this.m_reference = reference;
    }

    @Override
    public String getCodeId() {
        return this.getId();
    }

    @Override
    public void resolveReferences(XRefProblemReporter reporter) {
        this.m_enterpriseOid = this.getModule().resolveReference(this.m_enterpriseIdToken, SmiOidValue.class, reporter);
        for (IdToken variableToken : this.m_variableTokens) {
            SmiVariable variable = this.getModule().resolveReference(variableToken, SmiVariable.class, reporter);
            if (variable == null) continue;
            this.m_variables.add(variable);
        }
    }

    public IdToken getEnterpriseIdToken() {
        return this.m_enterpriseIdToken;
    }

    public SmiOidValue getEnterpriseOid() {
        return this.m_enterpriseOid;
    }

    public List<IdToken> getVariableTokens() {
        return this.m_variableTokens;
    }

    public List<SmiVariable> getVariables() {
        return this.m_variables;
    }

    @Override
    public List<SmiVariable> getObjects() {
        return this.m_variables;
    }

    @Override
    public List<IdToken> getObjectTokens() {
        return this.m_variableTokens;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public String getOidStr() {
        return this.getEnterpriseOid().getOidStr() + '.' + this.getSpecificType();
    }

    @Override
    public String getReference() {
        return this.m_reference;
    }

    public IntegerToken getSpecificTypeToken() {
        return this.m_specificTypeToken;
    }

    public void setSpecificTypeToken(IntegerToken specificTypeToken) {
        this.m_specificTypeToken = specificTypeToken;
    }

    public int getSpecificType() {
        return this.m_specificTypeToken.getValue();
    }
}

