/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.ScopedId;
import org.jsmiparser.smi.SmiIndex;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiObjectType;
import org.jsmiparser.smi.SmiOidNode;
import org.jsmiparser.smi.SmiTable;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.util.token.IdToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmiRow
extends SmiObjectType {
    private List<SmiRow> m_parentRows = new ArrayList<SmiRow>();
    private List<SmiRow> m_childRows = new ArrayList<SmiRow>();
    private List<SmiIndex> m_indexes;
    private ScopedId m_augmentsId;

    public SmiRow(IdToken idToken, SmiModule module) {
        super(idToken, module);
    }

    public SmiTable getTable() {
        return this.getNode().getParent().getSingleValue(SmiTable.class, this.getModule());
    }

    public List<SmiVariable> getColumns() {
        ArrayList<SmiVariable> result = new ArrayList<SmiVariable>();
        for (SmiOidNode smiOidNode : this.getNode().getChildren()) {
            result.add(smiOidNode.getSingleValue(SmiVariable.class));
        }
        return result;
    }

    public SmiRow getAugments() {
        if (this.m_augmentsId != null) {
            return (SmiRow)this.m_augmentsId.getSymbol();
        }
        return null;
    }

    public void setAugmentsId(ScopedId augmentsId) {
        this.m_augmentsId = augmentsId;
    }

    public List<SmiIndex> getIndexes() {
        return this.m_indexes;
    }

    public List<SmiRow> getChildRows() {
        return this.m_childRows;
    }

    public List<SmiRow> getParentRows() {
        return this.m_parentRows;
    }

    public SmiVariable findColumn(String id) {
        for (SmiVariable c : this.getColumns()) {
            if (!c.getId().equals(id)) continue;
            return c;
        }
        return null;
    }

    public SmiIndex addIndex(ScopedId scopedId, boolean isImplied) {
        if (this.m_indexes == null) {
            this.m_indexes = new ArrayList<SmiIndex>();
        }
        SmiIndex index = new SmiIndex(this, scopedId, isImplied);
        this.m_indexes.add(index);
        return index;
    }

    public boolean hasSameIndexes(SmiRow other) {
        boolean result = false;
        if (this.m_indexes.size() == other.m_indexes.size()) {
            boolean tmpResult = true;
            Iterator<SmiIndex> i = this.m_indexes.iterator();
            Iterator<SmiIndex> j = other.getIndexes().iterator();
            while (tmpResult && i.hasNext() && j.hasNext()) {
                SmiIndex i1 = i.next();
                SmiIndex i2 = j.next();
                if (i1.getColumn() != i2.getColumn()) {
                    tmpResult = false;
                }
                if (i1.isImplied() == i2.isImplied()) continue;
                System.out.printf("implied index is not the same for %s and %s", this.getId(), other.getId()).println();
                tmpResult = false;
            }
            result = tmpResult;
        }
        return result;
    }

    public void addParentRow(SmiRow row) {
        this.m_parentRows.add(row);
        row.m_childRows.add(this);
    }

    @Override
    public void resolveReferences(XRefProblemReporter reporter) {
        super.resolveReferences(reporter);
        if (this.m_indexes != null) {
            for (SmiIndex index : this.m_indexes) {
                index.resolveReferences(reporter);
            }
        } else {
            this.m_augmentsId.resolveReferences(reporter);
            SmiRow augmentedRow = this.getAugments();
            if (augmentedRow != null) {
                augmentedRow.m_childRows.add(this);
                this.m_parentRows.add(augmentedRow);
            }
        }
    }
}

