/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.math.BigInteger;
import org.jsmiparser.util.location.Location;
import org.jsmiparser.util.token.BigIntegerToken;
import org.jsmiparser.util.token.BinaryStringToken;
import org.jsmiparser.util.token.HexStringToken;
import org.jsmiparser.util.token.Token;

public class SmiRange {
    private Token m_beginToken;
    private Token m_endToken;

    public SmiRange(Token beginToken, Token endToken) {
        this.m_beginToken = beginToken;
        this.m_endToken = endToken;
    }

    public SmiRange(Token singleToken) {
        this.m_beginToken = singleToken;
        this.m_endToken = singleToken;
    }

    public Token getBeginToken() {
        return this.m_beginToken;
    }

    public Token getEndToken() {
        return this.m_endToken;
    }

    public boolean isSingle() {
        return this.m_beginToken == this.m_endToken;
    }

    public Location getLocation() {
        return this.m_beginToken.getLocation();
    }

    public BigInteger getMinValue() {
        return SmiRange.getValue(this.m_beginToken);
    }

    public BigInteger getMaxValue() {
        return SmiRange.getValue(this.m_endToken);
    }

    private static BigInteger getValue(Token token) {
        if (token instanceof BigIntegerToken) {
            return (BigInteger)((BigIntegerToken)token).getValue();
        }
        if (token instanceof HexStringToken) {
            return ((HexStringToken)token).getIntegerValue();
        }
        if (token instanceof BinaryStringToken) {
            return ((BinaryStringToken)token).getIntegerValue();
        }
        return null;
    }

    public String toString() {
        if (this.m_beginToken == this.m_endToken) {
            return this.m_beginToken.getObject().toString();
        }
        StringBuilder result = new StringBuilder("(");
        result.append(this.m_beginToken.getObject());
        result.append("..");
        result.append(this.m_endToken);
        result.append(")");
        return result.toString();
    }
}

