/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import org.jsmiparser.smi.SmiVarBindField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SmiPrimitiveType {
    ENUM(SmiVarBindField.INTEGER_VALUE, "", true, true),
    INTEGER(SmiVarBindField.INTEGER_VALUE, "Int", true, true),
    OCTET_STRING(SmiVarBindField.STRING_VALUE, "Octs", false, true),
    OBJECT_IDENTIFIER(SmiVarBindField.OBJECTID_VALUE, "Oid", false, true),
    INTEGER_32(SmiVarBindField.INTEGER_VALUE, "Integer32", false, true),
    IP_ADDRESS(SmiVarBindField.IPADDRESS_VALUE, "IpAddress", false, true),
    COUNTER_32(SmiVarBindField.COUNTER_VALUE, "Counter32", false, true),
    GAUGE_32(SmiVarBindField.UNSIGNED_INTEGER_VALUE, "Gauge32", false, true),
    UNSIGNED_32(SmiVarBindField.UNSIGNED_INTEGER_VALUE, "Unsigned32", false, true),
    TIME_TICKS(SmiVarBindField.TIMETICKS_VALUE, "TimeTicks", false, true),
    OPAQUE(SmiVarBindField.ARBITRARY_VALUE, "Opaque", false, true),
    COUNTER_64(SmiVarBindField.BIG_COUNTER_VALUE, "Counter64", false, true),
    BITS(SmiVarBindField.STRING_VALUE, "Bits", false, true);

    private SmiVarBindField m_varBindField;
    private String m_xmlValue;
    private boolean m_namedNumbersSupported;
    private boolean m_rangesSupported;

    private SmiPrimitiveType(SmiVarBindField varBindField, String xmlValue, boolean allowsNamedNumbers, boolean allowsRanges) {
        this.m_varBindField = varBindField;
        this.m_xmlValue = xmlValue;
        this.m_namedNumbersSupported = allowsNamedNumbers;
        this.m_rangesSupported = allowsRanges;
    }

    public SmiVarBindField getVarBindField() {
        return this.m_varBindField;
    }

    public SmiPrimitiveType fromXmlValue(String xmlValue) {
        for (SmiPrimitiveType pt : SmiPrimitiveType.values()) {
            if (!pt.m_xmlValue.equals(xmlValue)) continue;
            return pt;
        }
        return null;
    }

    public String getXmlValue() {
        return this.m_xmlValue;
    }

    public boolean isNamedNumbersSupported() {
        return this.m_namedNumbersSupported;
    }

    public boolean isRangesSupported() {
        return this.m_rangesSupported;
    }
}

