/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiOidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmiOidNode {
    private final SmiOidNode m_parent;
    Map<Integer, SmiOidNode> m_childMap = new TreeMap<Integer, SmiOidNode>();
    private List<SmiOidValue> m_values = new ArrayList<SmiOidValue>();
    private final int m_value;
    private int[] m_oid;
    private String m_oidStr;

    public SmiOidNode(SmiOidNode parent, int value) {
        this.m_parent = parent;
        this.m_value = value;
        if (this.m_parent != null) {
            if (this.m_parent.m_childMap.get(value) != null) {
                throw new IllegalStateException();
            }
            this.m_parent.m_childMap.put(value, this);
        }
    }

    public SmiOidNode getParent() {
        return this.m_parent;
    }

    public Collection<? extends SmiOidNode> getChildren() {
        return this.m_childMap.values();
    }

    public List<SmiOidValue> getValues() {
        return this.m_values;
    }

    public int[] getOid() {
        return this.m_oid;
    }

    public String getOidStr() {
        return this.m_oidStr;
    }

    public int getTotalChildCount() {
        int result = this.m_childMap.size();
        for (SmiOidNode child : this.m_childMap.values()) {
            result += child.getTotalChildCount();
        }
        return result;
    }

    public void dumpTree(PrintStream w, String indent) {
        w.print(indent);
        w.print(this.m_value);
        for (SmiOidValue value : this.m_values) {
            w.print(":");
            w.print(value.getId());
        }
        for (SmiOidNode child : this.m_childMap.values()) {
            child.dumpTree(w, indent + " ");
        }
    }

    public static SmiOidNode createRootNode() {
        return new SmiOidNode(null, -1);
    }

    public SmiOidNode findChild(int value) {
        return this.m_childMap.get(value);
    }

    public <T extends SmiOidValue> T getSingleValue(Class<T> clazz) {
        if (this.m_values.size() != 1) {
            throw new AssertionError((Object)"expected only a single value");
        }
        return (T)((SmiOidValue)clazz.cast(this.m_values.get(0)));
    }

    public <T extends SmiOidValue> T getSingleValue(Class<T> clazz, SmiModule module) {
        SmiOidValue result = null;
        for (SmiOidValue value : this.m_values) {
            if (value.getModule() != module || !clazz.isInstance(value)) continue;
            if (result == null) {
                result = (SmiOidValue)clazz.cast(value);
                continue;
            }
            throw new IllegalArgumentException("more than one found");
        }
        return (T)result;
    }

    public SmiOidValue getSingleValue() {
        if (this.m_values.size() != 1) {
            throw new AssertionError((Object)"expected only a single value");
        }
        return this.m_values.get(0);
    }

    public SmiOidNode getRootNode() {
        SmiOidNode parent = this;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    public void dumpAncestors(PrintStream out) {
        for (SmiOidNode oidValue = this; oidValue != null; oidValue = oidValue.getParent()) {
            out.print(oidValue.m_value);
            for (SmiOidValue value : this.m_values) {
                out.print(",");
                out.print(value.getId());
            }
            if (oidValue.getParent() == null) continue;
            out.print(": ");
        }
        out.println();
    }

    public int[] determineFullOid() {
        SmiOidNode parent;
        if (this.m_oid == null && (parent = this.getParent()) != null) {
            int[] parentOid = parent.determineFullOid();
            if (parentOid != null) {
                this.m_oid = new int[parentOid.length + 1];
                System.arraycopy(parentOid, 0, this.m_oid, 0, parentOid.length);
                this.m_oid[this.m_oid.length - 1] = this.m_value;
                this.m_oidStr = parent.getOidStr() + "." + this.m_value;
            } else {
                this.m_oid = new int[]{this.m_value};
                this.m_oidStr = String.valueOf(this.m_value);
            }
        }
        return this.m_oid;
    }

    public boolean contains(SmiOidNode node) {
        return this.m_childMap.containsValue(node);
    }

    public int getValue() {
        return this.m_value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.m_oidStr;
    }
}

