/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import org.jsmiparser.smi.SmiCodeNamingStrategy;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiNamedNumber;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiSymbol;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.smi.SmiUtil;
import org.jsmiparser.smi.SmiVariable;

public class SmiJavaCodeNamingStrategy
implements SmiCodeNamingStrategy {
    public static final String ATTR_OIDS = "AttrOids";
    private String packagePrefix_;

    public SmiJavaCodeNamingStrategy(String packagePrefix) {
        this.packagePrefix_ = packagePrefix;
    }

    public String getModuleId(SmiModule module) {
        String[] parts;
        StringBuilder result = new StringBuilder();
        for (String str : parts = module.getId().split("[^_0-9A-Za-z]")) {
            result.append(SmiUtil.ucFirst(str.toLowerCase()));
        }
        return result.toString();
    }

    public String getFullModuleId(SmiModule module) {
        return this.packagePrefix_ + "." + this.getModuleId(module).toLowerCase();
    }

    public String getCodeConstantId(SmiVariable variable) {
        return this.makeConstant(variable.getId());
    }

    public String getFullCodeConstantId(SmiVariable variable) {
        return variable.getModule().getFullVariableOidClassId() + "." + variable.getCodeConstantId();
    }

    public String makeConstant(String str) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        String prev = null;
        while (i < str.length()) {
            int j = i;
            Category cat = this.getCategory(str.charAt(j));
            ++j;
            while (j < str.length() && this.getCategory(str.charAt(j)) == cat) {
                ++j;
            }
            String current = str.substring(i, j);
            i = j;
            prev = this.processPrevious(result, prev, cat, current);
        }
        prev = this.append(result, prev, null);
        return result.toString();
    }

    private String processPrevious(StringBuilder result, String prev, Category cat, String current) {
        String newPrev = null;
        if (prev == null) {
            newPrev = current;
        } else {
            switch (this.getCategory(prev.charAt(0))) {
                case DIGIT: {
                    newPrev = this.append(result, prev, current);
                    break;
                }
                case UPPER: {
                    if (cat == Category.LOWER) {
                        if (prev.length() == 1) {
                            newPrev = prev + current;
                            break;
                        }
                        current = prev.charAt(prev.length() - 1) + current;
                        prev = prev.substring(0, prev.length() - 1);
                        newPrev = this.append(result, prev, current);
                        break;
                    }
                    newPrev = this.append(result, prev, current);
                    break;
                }
                case LOWER: {
                    newPrev = this.append(result, prev, current);
                    break;
                }
                case OTHER: {
                    newPrev = current;
                }
            }
        }
        return newPrev;
    }

    private String append(StringBuilder result, String prev, String current) {
        if (result.length() != 0) {
            result.append('_');
        }
        result.append(prev.toUpperCase());
        return current;
    }

    private Category getCategory(char ch) {
        if (Character.isUpperCase(ch)) {
            return Category.UPPER;
        }
        if (Character.isLowerCase(ch)) {
            return Category.LOWER;
        }
        if (Character.isDigit(ch)) {
            return Category.DIGIT;
        }
        return Category.OTHER;
    }

    public String getTypeId(SmiType type) {
        return type.getId();
    }

    public String getOidValueId(SmiOidValue oidValue) {
        return oidValue.getId();
    }

    public String getSingleVariableEnumId(SmiVariable attr) {
        return SmiUtil.ucFirst(attr.getCodeId());
    }

    public String getEnumValueId(SmiNamedNumber ev) {
        return this.makeConstant(ev.getId());
    }

    public String getRequestMethodId(SmiVariable attr) {
        return "req" + SmiUtil.ucFirst(attr.getCodeId());
    }

    public String getGetterMethodId(SmiVariable attr) {
        return "get" + SmiUtil.ucFirst(attr.getCodeId());
    }

    public String getSetterMethodId(SmiVariable attr) {
        return "set" + SmiUtil.ucFirst(attr.getCodeId());
    }

    public String getFullCodeId(SmiSymbol symbol) {
        return symbol.getModule().getFullCodeId() + "." + symbol.getCodeId();
    }

    public String getFullVariableOidClassId(SmiModule module) {
        return module.getFullCodeId() + "." + module.getVariableOidClassId();
    }

    public String getVariableOidClassId(SmiModule module) {
        return module.getCodeId().toUpperCase() + ATTR_OIDS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Category {
        UPPER,
        LOWER,
        DIGIT,
        OTHER;

    }
}

