/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiSymbol;
import org.jsmiparser.util.location.Location;
import org.jsmiparser.util.pair.Pair;
import org.jsmiparser.util.token.IdToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmiImports {
    static final String[] V1_V2_MAP = new String[]{"RFC1155-SMI", "internet", "SNMPv2-SMI", "internet", "RFC1155-SMI", "directory", "SNMPv2-SMI", "directory", "RFC1155-SMI", "mgmt", "SNMPv2-SMI", "mgmt", "RFC1155-SMI", "experimental", "SNMPv2-SMI", "experimental", "RFC1155-SMI", "private", "SNMPv2-SMI", "private", "RFC1155-SMI", "enterprises", "SNMPv2-SMI", "enterprises", "RFC1155-SMI", "IpAddress", "SNMPv2-SMI", "IpAddress", "RFC1155-SMI", "Counter", "SNMPv2-SMI", "Counter32", "RFC1155-SMI", "Gauge", "SNMPv2-SMI", "Gauge32", "RFC1155-SMI", "TimeTicks", "SNMPv2-SMI", "TimeTicks", "RFC1155-SMI", "Opaque", "SNMPv2-SMI", "Opaque", "RFC1065-SMI", "internet", "SNMPv2-SMI", "internet", "RFC1065-SMI", "directory", "SNMPv2-SMI", "directory", "RFC1065-SMI", "mgmt", "SNMPv2-SMI", "mgmt", "RFC1065-SMI", "experimental", "SNMPv2-SMI", "experimental", "RFC1065-SMI", "private", "SNMPv2-SMI", "private", "RFC1065-SMI", "enterprises", "SNMPv2-SMI", "enterprises", "RFC1065-SMI", "IpAddress", "SNMPv2-SMI", "IpAddress", "RFC1065-SMI", "Counter", "SNMPv2-SMI", "Counter32", "RFC1065-SMI", "Gauge", "SNMPv2-SMI", "Gauge32", "RFC1065-SMI", "TimeTicks", "SNMPv2-SMI", "TimeTicks", "RFC1065-SMI", "Opaque", "SNMPv2-SMI", "Opaque", "RFC1213-MIB", "mib-2", "SNMPv2-SMI", "mib-2", "RFC1213-MIB", "DisplayString", "SNMPv2-TC", "DisplayString", "RFC-1212", "OBJECT-TYPE", "SNMPv2-SMI", "OBJECT-TYPE"};
    private final SmiModule m_importerModule;
    private final IdToken m_moduleToken;
    private final List<IdToken> m_symbolTokens;
    private SmiModule m_module;
    private LinkedHashMap<String, SmiSymbol> m_symbolMap = new LinkedHashMap();

    public SmiImports(SmiModule importerModule, IdToken moduleToken, List<IdToken> symbolTokens) {
        assert (importerModule != null);
        assert (moduleToken != null);
        assert (symbolTokens != null);
        this.m_importerModule = importerModule;
        this.m_moduleToken = moduleToken;
        this.m_symbolTokens = Collections.unmodifiableList(symbolTokens);
    }

    public SmiModule getModule() {
        return this.m_module;
    }

    public Collection<SmiSymbol> getSymbols() {
        return this.m_symbolMap.values();
    }

    public IdToken getModuleToken() {
        return this.m_moduleToken;
    }

    public List<IdToken> getSymbolTokens() {
        return this.m_symbolTokens;
    }

    public Location getLocation() {
        return this.m_moduleToken.getLocation();
    }

    public SmiSymbol find(String id) {
        return this.m_symbolMap.get(id);
    }

    public void resolveImports(XRefProblemReporter reporter) {
        this.m_module = this.m_importerModule.getMib().findModule(this.m_moduleToken.getId());
        if (this.m_module != null) {
            for (IdToken idToken : this.getSymbolTokens()) {
                SmiSymbol symbol = this.getModule().findSymbol(idToken.getId());
                if (symbol != null) {
                    this.m_symbolMap.put(idToken.getId(), symbol);
                    continue;
                }
                reporter.reportCannotFindImportedSymbol(idToken, this.m_moduleToken);
            }
        } else if (this.m_importerModule.getMib().getOptions().isConvertV1ImportsToV2()) {
            this.resolveV1Imports(reporter);
        } else {
            reporter.reportCannotFindModule(this.m_moduleToken);
        }
    }

    private void resolveV1Imports(XRefProblemReporter reporter) {
        for (IdToken idToken : this.getSymbolTokens()) {
            Pair<String, String> v2Definition = this.findV2Definition(idToken.getId());
            if (v2Definition != null) {
                SmiModule module = this.m_importerModule.getMib().findModule((String)v2Definition.getFirst());
                if (module != null) {
                    SmiSymbol symbol = module.findSymbol((String)v2Definition.getSecond());
                    if (symbol != null) {
                        this.m_symbolMap.put(idToken.getId(), symbol);
                        continue;
                    }
                    reporter.reportCannotFindImportedSymbol(idToken, this.m_moduleToken);
                    continue;
                }
                reporter.reportCannotFindModule(this.m_moduleToken);
                continue;
            }
            reporter.reportCannotFindImportedSymbol(idToken, this.m_moduleToken);
        }
    }

    public Pair<String, String> findV2Definition(String id) {
        for (int i = 0; i < V1_V2_MAP.length; i += 4) {
            String oldMib = V1_V2_MAP[i];
            String oldId = V1_V2_MAP[i + 1];
            if (!oldMib.equals(this.m_moduleToken.getId()) || !oldId.equals(id)) continue;
            return new Pair((Object)V1_V2_MAP[i + 2], (Object)V1_V2_MAP[i + 3]);
        }
        return null;
    }
}

