/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.OidComponent;
import org.jsmiparser.smi.ScopedId;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiNamedNumber;
import org.jsmiparser.smi.SmiOidNode;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiPrimitiveType;
import org.jsmiparser.smi.SmiSymbol;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.util.token.BigIntegerToken;
import org.jsmiparser.util.token.BinaryStringToken;
import org.jsmiparser.util.token.HexStringToken;
import org.jsmiparser.util.token.IdToken;
import org.jsmiparser.util.token.QuotedStringToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmiDefaultValue {
    private static final Logger m_log = LoggerFactory.getLogger(SmiDefaultValue.class);
    private final SmiModule m_module;
    private final BigIntegerToken m_bigIntegerToken;
    private final List<IdToken> m_bitsIdTokenList;
    private final OidComponent m_lastOidComponent;
    private final BinaryStringToken m_binaryStringToken;
    private final HexStringToken m_hexStringToken;
    private final QuotedStringToken m_quotedStringToken;
    private final ScopedId m_scopedId;
    private final boolean m_isNullValue;
    SmiVariable m_variable;
    private ArrayList<SmiNamedNumber> m_bitsValue;
    private SmiNamedNumber m_enumValue;
    private SmiOidValue m_oidValue;
    private SmiOidNode m_oidNode;
    private SmiSymbol m_symbolValue;

    public SmiDefaultValue(SmiModule module, BigIntegerToken bigIntegerToken, List<IdToken> bitsIdTokenList, OidComponent lastOidComponent, BinaryStringToken binaryStringToken, HexStringToken hexStringToken, QuotedStringToken quotedStringToken, ScopedId scopedId, boolean nullValue) {
        this.m_module = module;
        this.m_bigIntegerToken = bigIntegerToken;
        this.m_bitsIdTokenList = bitsIdTokenList;
        this.m_lastOidComponent = lastOidComponent;
        this.m_binaryStringToken = binaryStringToken;
        this.m_hexStringToken = hexStringToken;
        this.m_quotedStringToken = quotedStringToken;
        this.m_scopedId = scopedId;
        this.m_isNullValue = nullValue;
    }

    public SmiVariable getVariable() {
        return this.m_variable;
    }

    public BigInteger getIntegerValue() {
        if (this.m_bigIntegerToken != null) {
            return (BigInteger)this.m_bigIntegerToken.getValue();
        }
        return null;
    }

    public List<SmiNamedNumber> getBitsValue() {
        return this.m_bitsValue;
    }

    public SmiNamedNumber getEnumValue() {
        return this.m_enumValue;
    }

    public SmiOidValue getOidValue() {
        return this.m_oidValue;
    }

    public SmiOidNode getOidNode() {
        if (this.m_oidNode != null) {
            return this.m_oidNode;
        }
        if (this.m_oidValue != null) {
            return this.m_oidValue.getNode();
        }
        return null;
    }

    public String getCStringValue() {
        if (this.m_quotedStringToken != null) {
            return (String)this.m_quotedStringToken.getValue();
        }
        return null;
    }

    public String getBinaryStringValue() {
        if (this.m_binaryStringToken != null) {
            return (String)this.m_binaryStringToken.getValue();
        }
        return null;
    }

    public String getHexStringValue() {
        if (this.m_hexStringToken != null) {
            return (String)this.m_hexStringToken.getValue();
        }
        return null;
    }

    public SmiSymbol getSymbolValue() {
        return this.m_symbolValue;
    }

    public BigIntegerToken getBigIntegerToken() {
        return this.m_bigIntegerToken;
    }

    public List<IdToken> getBitsIdTokenList() {
        return this.m_bitsIdTokenList;
    }

    public OidComponent getLastOidComponents() {
        return this.m_lastOidComponent;
    }

    public BinaryStringToken getBinaryStringToken() {
        return this.m_binaryStringToken;
    }

    public HexStringToken getHexStringToken() {
        return this.m_hexStringToken;
    }

    public QuotedStringToken getQuotedStringToken() {
        return this.m_quotedStringToken;
    }

    public ScopedId getScopedId() {
        return this.m_scopedId;
    }

    public boolean isNullValue() {
        return this.m_isNullValue;
    }

    public void resolveReferences(XRefProblemReporter reporter) {
        if (this.m_bitsIdTokenList != null) {
            this.resolveBits(reporter);
        } else if (this.m_lastOidComponent != null) {
            this.m_oidNode = this.resolveOids(reporter);
        } else if (this.m_scopedId != null) {
            if (this.m_scopedId.getModuleToken() != null) {
                m_log.debug("Not yet implemented: " + this.m_scopedId.getModuleToken());
            } else if (this.m_variable.getEnumValues() != null) {
                this.m_enumValue = this.m_variable.resolveEnumConstant(this.m_scopedId.getSymbolToken(), reporter);
            } else {
                SmiSymbol symbol = this.m_variable.getModule().resolveReference(this.m_scopedId.getSymbolToken(), reporter);
                if (symbol != null) {
                    if (symbol instanceof SmiOidValue && this.m_variable.getPrimitiveType() == SmiPrimitiveType.OBJECT_IDENTIFIER) {
                        this.m_oidValue = (SmiOidValue)symbol;
                        this.m_oidNode = this.m_oidValue.getNode();
                    } else {
                        this.m_symbolValue = symbol;
                        reporter.reportInvalidDefaultValue(this.m_scopedId.getSymbolToken());
                    }
                }
            }
        }
    }

    private SmiOidNode resolveOids(XRefProblemReporter reporter) {
        return this.m_lastOidComponent.resolveNode(this.m_module, reporter);
    }

    private void resolveBits(XRefProblemReporter reporter) {
        if (this.m_variable.getBitFields() != null) {
            this.m_bitsValue = new ArrayList();
            for (IdToken idToken : this.m_bitsIdTokenList) {
                SmiNamedNumber nn = this.m_variable.resolveBitField(idToken, reporter);
                this.m_bitsValue.add(nn);
            }
        } else {
            reporter.reportBitsValueWithoutBitsType(this.m_bitsIdTokenList.get(0).getLocation());
        }
    }
}

