/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.smi;

import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiOidNode;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiSymbol;
import org.jsmiparser.util.token.IdToken;
import org.jsmiparser.util.token.IntegerToken;
import org.jsmiparser.util.token.Token;

public class OidComponent {
    private final OidComponent m_parent;
    private OidComponent m_child;
    private final IdToken m_idToken;
    private final IntegerToken m_valueToken;
    private SmiOidNode m_node;
    private boolean m_isResolved = false;

    public OidComponent(OidComponent parent, IdToken idToken, IntegerToken intToken) {
        this.m_parent = parent;
        if (this.m_parent != null) {
            this.m_parent.m_child = this;
        }
        this.m_idToken = idToken;
        this.m_valueToken = intToken;
    }

    public IdToken getIdToken() {
        return this.m_idToken;
    }

    public IntegerToken getValueToken() {
        return this.m_valueToken;
    }

    public SmiOidNode getNode() {
        return this.m_node;
    }

    private Token getToken() {
        if (this.m_idToken != null) {
            return this.m_idToken;
        }
        return this.m_valueToken;
    }

    private boolean isFirst() {
        return this.m_parent == null;
    }

    private boolean isLast() {
        return this.m_child == null;
    }

    public SmiOidNode resolveNode(SmiModule module, XRefProblemReporter reporter) {
        assert (this.m_node == null);
        if (!this.m_isResolved) {
            SmiOidNode parent = null;
            if (this.m_parent != null && (parent = this.m_parent.resolveNode(module, reporter)) == null) {
                reporter.reportCannotFindParent(this.m_parent.getToken());
            }
            this.m_node = this.doResolve(module, parent, reporter);
            if (this.m_node == null) {
                if (this.isLast()) {
                    if (parent != null) {
                        if (this.m_valueToken != null) {
                            this.m_node = new SmiOidNode(parent, this.m_valueToken.getValue());
                        } else {
                            reporter.reportValueTokenMissingForLastSubid(this.getToken());
                        }
                    } else {
                        reporter.reporParentMissingForLastSubid(this.getToken());
                    }
                } else {
                    reporter.reportCannotResolveNonLastSubid(this.getToken());
                }
            }
            this.m_isResolved = true;
        }
        return this.m_node;
    }

    /*
     * Enabled aggressive block sorting
     */
    private SmiOidNode doResolve(SmiModule module, SmiOidNode parent, XRefProblemReporter reporter) {
        SmiOidNode node;
        if (this.m_idToken != null && !this.isLast()) {
            SmiSymbol symbol = module.resolveReference(this.m_idToken, null);
            if (symbol != null) {
                if (symbol instanceof SmiOidValue) {
                    SmiOidValue oidValue = (SmiOidValue)symbol;
                    node = oidValue.resolveOid(reporter);
                    if (node == null) return node;
                    if (this.m_valueToken == null) return node;
                    return node;
                }
                reporter.reportFoundSymbolButWrongType(this.m_idToken, SmiOidValue.class, symbol.getClass());
                return null;
            }
            if (parent == null) return null;
            if (this.m_valueToken == null) return null;
            int value = this.m_valueToken.getValue();
            node = parent.m_childMap.get(value);
            if (node != null) return node;
            return new SmiOidNode(parent, value);
        }
        if (this.isFirst()) {
            node = module.getMib().getRootNode().findChild(this.m_valueToken.getValue());
            if (node != null) return node;
            return new SmiOidNode(module.getMib().getRootNode(), this.m_valueToken.getValue());
        }
        if (parent == null) return null;
        node = parent.findChild(this.m_valueToken.getValue());
        if (node != null) return node;
        return new SmiOidNode(parent, this.m_valueToken.getValue());
    }
}

