/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.phase.xref;

import org.jsmiparser.smi.SmiSymbol;
import org.jsmiparser.util.location.Location;
import org.jsmiparser.util.problem.annotations.ProblemMethod;
import org.jsmiparser.util.problem.annotations.ProblemSeverity;
import org.jsmiparser.util.token.IdToken;
import org.jsmiparser.util.token.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface XRefProblemReporter {
    @ProblemMethod(message="Cannot find module %s")
    public void reportCannotFindModule(IdToken var1);

    @ProblemMethod(message="Cannot find imported symbol %s in module %s")
    public void reportCannotFindImportedSymbol(IdToken var1, IdToken var2);

    @ProblemMethod(message="Cannot find symbol %s")
    public void reportCannotFindSymbol(IdToken var1);

    @ProblemMethod(message="Found symbol %s but expected a %s instead of %s")
    public void reportFoundSymbolButWrongType(IdToken var1, Class<? extends SmiSymbol> var2, Class<? extends SmiSymbol> var3);

    @ProblemMethod(message="DEFVAL with bit values but variable doesn't have a BITS type.")
    public void reportBitsValueWithoutBitsType(Location var1);

    @ProblemMethod(message="Cannot find bit field %s")
    public void reportCannotFindBitField(IdToken var1);

    @ProblemMethod(message="Cannot find enum constant %s")
    public void reportCannotFindEnumConstant(IdToken var1);

    @ProblemMethod(message="Invalid default value %s", severity=ProblemSeverity.WARNING)
    public void reportInvalidDefaultValue(IdToken var1);

    @ProblemMethod(message="An object identifier default value must be expressed as a single ASN.1 identifier, and not as a collection of sub-identifiers: %s", ref="RFC1902, 7.9")
    public void reportOidDefaultValueMustBeSingleIdentifier(Token var1);

    @ProblemMethod(message="%s is not a valid value for the ACCESS(SMIv1) field. You are probably mixing v1/v2 constructions.", severity=ProblemSeverity.WARNING)
    public void reportInvalidAccess(IdToken var1);

    @ProblemMethod(message="%s is not a valid value for the MAX-ACCESS(SMIv2) field. You are probably mixing v1/v2 constructions.", severity=ProblemSeverity.WARNING)
    public void reportInvalidMaxAccess(IdToken var1);

    @ProblemMethod(message="Couldn't find parent for %s")
    public void reportCannotFindParent(Token var1);

    @ProblemMethod(message="valueToken missing for last subid %s")
    public void reportValueTokenMissingForLastSubid(Token var1);

    @ProblemMethod(message="Parent missing for last subid %s")
    public void reporParentMissingForLastSubid(Token var1);

    @ProblemMethod(message="Couldn't resolve non-last subid %s")
    public void reportCannotResolveNonLastSubid(Token var1);
}

