/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.phase.xref;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jsmiparser.exception.SmiException;
import org.jsmiparser.phase.Phase;
import org.jsmiparser.phase.xref.SymbolDefiner;
import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.SmiDefaultValue;
import org.jsmiparser.smi.SmiMib;
import org.jsmiparser.smi.SmiModule;
import org.jsmiparser.smi.SmiOidNode;
import org.jsmiparser.smi.SmiOidValue;
import org.jsmiparser.smi.SmiSymbol;
import org.jsmiparser.smi.SmiVariable;
import org.jsmiparser.util.problem.DefaultProblemReporterFactory;
import org.jsmiparser.util.problem.ProblemEventHandler;
import org.jsmiparser.util.problem.ProblemReporterFactory;
import org.jsmiparser.util.token.IdToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XRefPhase
implements Phase {
    private static final Logger m_log = LoggerFactory.getLogger(XRefPhase.class);
    private XRefProblemReporter m_reporter;
    private Map<String, SymbolDefiner> m_symbolDefinerMap = new LinkedHashMap<String, SymbolDefiner>();

    public XRefPhase(XRefProblemReporter reporter) {
        this.m_reporter = reporter;
    }

    public XRefPhase(ProblemReporterFactory reporterFactory) {
        this.m_reporter = (XRefProblemReporter)reporterFactory.create(XRefProblemReporter.class);
    }

    public XRefPhase(ProblemEventHandler eventHandler) {
        DefaultProblemReporterFactory reporterFactory = new DefaultProblemReporterFactory(eventHandler);
        this.m_reporter = (XRefProblemReporter)reporterFactory.create(XRefProblemReporter.class);
    }

    public Object getOptions() {
        return null;
    }

    public Map<String, SymbolDefiner> getSymbolDefinerMap() {
        return this.m_symbolDefinerMap;
    }

    public void setSymbolDefinerMap(Map<String, SymbolDefiner> symbolDefinerMap) {
        this.m_symbolDefinerMap = symbolDefinerMap;
    }

    public XRefPhase addSymbolDefiner(String moduleId, SymbolDefiner symbolDefiner) {
        this.m_symbolDefinerMap.put(moduleId, symbolDefiner);
        return this;
    }

    public XRefPhase addSymbolDefiner(SymbolDefiner symbolDefiner) {
        this.m_symbolDefinerMap.put(symbolDefiner.getModuleId(), symbolDefiner);
        return this;
    }

    public XRefPhase addSymbolDefiners(SymbolDefiner ... symbolDefiners) {
        for (SymbolDefiner symbolDefiner : symbolDefiners) {
            this.m_symbolDefinerMap.put(symbolDefiner.getModuleId(), symbolDefiner);
        }
        return this;
    }

    @Override
    public SmiMib process(SmiMib mib) throws SmiException {
        this.defineMissingSymbols(mib);
        mib.fillTables();
        mib.defineMissingStandardOids();
        for (SmiModule module : mib.getModules()) {
            module.resolveImports(this.m_reporter);
        }
        Collection<SmiModule> modules = mib.getModules();
        this.resolveReferences(modules);
        this.resolveOids(modules);
        mib.fillExtraTables();
        this.resolveDefaultValues(mib);
        return mib;
    }

    protected void defineMissingSymbols(SmiMib mib) {
        for (Map.Entry<String, SymbolDefiner> entry : this.m_symbolDefinerMap.entrySet()) {
            SmiModule module = mib.findModule(entry.getKey());
            if (module == null) {
                module = mib.createModule(new IdToken(null, entry.getKey()));
            }
            entry.getValue().defineSymbols(module);
        }
    }

    protected void resolveReferences(Collection<SmiModule> modules) {
        for (SmiModule module : modules) {
            for (SmiSymbol symbol : module.getSymbols()) {
                symbol.resolveReferences(this.m_reporter);
            }
        }
    }

    protected void resolveOids(Collection<SmiModule> modules) {
        for (SmiModule module : modules) {
            m_log.debug("Resolving oids in module: " + module.getId() + " hash=" + module.getId().hashCode());
            for (SmiOidValue oidValue : module.getOidValues()) {
                oidValue.resolveOid(this.m_reporter);
            }
        }
        for (SmiModule module : modules) {
            for (SmiOidValue oidValue : module.getOidValues()) {
                SmiOidNode node = oidValue.getNode();
                if (node == null) continue;
                node.determineFullOid();
            }
        }
    }

    protected void resolveDefaultValues(SmiMib mib) {
        for (SmiVariable variable : mib.getVariables()) {
            SmiDefaultValue defaultValue = variable.getDefaultValue();
            if (defaultValue == null) continue;
            defaultValue.resolveReferences(this.m_reporter);
        }
    }
}

