/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.phase.xref;

import java.util.ArrayList;
import org.jsmiparser.phase.xref.AbstractSymbolDefiner;
import org.jsmiparser.smi.SmiConstants;
import org.jsmiparser.smi.SmiRange;
import org.jsmiparser.smi.SmiType;
import org.jsmiparser.util.pair.StringIntPair;
import org.jsmiparser.util.token.BigIntegerToken;
import org.jsmiparser.util.token.Token;

public class SNMPv2_SMISymbolDefiner
extends AbstractSymbolDefiner {
    public SNMPv2_SMISymbolDefiner() {
        super("SNMPv2-SMI");
    }

    protected void defineSymbols() {
        super.defineSymbols();
        this.addOrgOid();
        this.addDodOid();
        this.addInternetOid();
        this.addDirectoryOid();
        this.addMgmtOid();
        this.addMib2Oid();
        this.addTransmissionOid();
        this.addExperimentalOid();
        this.addPrivateOid();
        this.addEnterprisesOid();
        this.addSnmpV2Oid();
        this.addSnmpDomainsOid();
        this.addSnmpProxysOid();
        this.addSnmpModulesOid();
        this.addExtUTCTimeType();
        this.addModuleIdentityMacro();
        this.addObjectIdentityMacro();
        this.addObjectNameType();
        this.addNotificationNameType();
        this.addObjectSyntaxType();
        this.addSimpleSyntaxType();
        this.addInteger32Type();
        this.addApplicationSyntaxType();
        this.addNetworkAddressType();
        this.addIpAddressType();
        this.addCounter32Type();
        this.addGauge32Type();
        this.addTimeTicksType();
        this.addOpaqueType();
        this.addCounter64Type();
        this.addObjectTypeMacro();
        this.addNotificationTypeMacro();
        this.addZeroDotZeroObjectIdentity();
    }

    private void addSnmpV2Oid() {
        this.addOid("snmpV2", new StringIntPair("internet"), new StringIntPair(Integer.valueOf(6)));
    }

    private void addSnmpDomainsOid() {
        this.addOid("snmpDomains", new StringIntPair("snmpV2"), new StringIntPair(Integer.valueOf(1)));
    }

    private void addSnmpProxysOid() {
        this.addOid("snmpProxys", new StringIntPair("snmpV2"), new StringIntPair(Integer.valueOf(2)));
    }

    private void addSnmpModulesOid() {
        this.addOid("snmpModules", new StringIntPair("snmpV2"), new StringIntPair(Integer.valueOf(3)));
    }

    private void addExtUTCTimeType() {
        if (this.isMissing("ExtUTCTime")) {
            SmiType type = new SmiType(this.idt("ExtUTCTime"), this.m_module);
            type.setBaseType(SmiConstants.OCTET_STRING_TYPE);
            ArrayList<SmiRange> constraints = new ArrayList<SmiRange>();
            constraints.add(new SmiRange((Token)new BigIntegerToken(11)));
            constraints.add(new SmiRange((Token)new BigIntegerToken(13)));
            type.setSizeConstraints(constraints);
            this.m_module.addSymbol(type);
        }
    }

    private void addModuleIdentityMacro() {
        this.addMacro("MODULE-IDENTITY");
    }

    private void addObjectIdentityMacro() {
        this.addMacro("OBJECT-IDENTITY");
    }

    private void addNotificationTypeMacro() {
        this.addMacro("NOTIFICATION-TYPE");
    }

    private void addZeroDotZeroObjectIdentity() {
        this.addOid("zeroDotZero", new StringIntPair(Integer.valueOf(0)), new StringIntPair(Integer.valueOf(0)));
    }
}

