/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.parser;

import org.jsmiparser.exception.SmiException;
import org.jsmiparser.parser.SmiParser;
import org.jsmiparser.phase.Phase;
import org.jsmiparser.phase.check.ErrorCheckPhase;
import org.jsmiparser.phase.file.FileParserPhase;
import org.jsmiparser.phase.file.FileParserProblemReporter;
import org.jsmiparser.phase.xref.XRefPhase;
import org.jsmiparser.phase.xref.XRefProblemReporter;
import org.jsmiparser.smi.SmiJavaCodeNamingStrategy;
import org.jsmiparser.smi.SmiMib;
import org.jsmiparser.smi.SmiOptions;
import org.jsmiparser.util.problem.DefaultProblemEventHandler;
import org.jsmiparser.util.problem.DefaultProblemReporterFactory;
import org.jsmiparser.util.problem.ProblemEventHandler;
import org.jsmiparser.util.problem.ProblemReporterFactory;

public class SmiDefaultParser
implements SmiParser {
    protected boolean m_failOnError = false;
    protected ProblemReporterFactory m_problemReporterFactory;
    protected FileParserPhase m_fileParserPhase;
    protected XRefPhase m_xRefPhase;
    protected ErrorCheckPhase m_errorCheckPhase;
    protected SmiOptions options = new SmiOptions();

    public SmiDefaultParser() {
        this((ProblemEventHandler)new DefaultProblemEventHandler());
    }

    public SmiDefaultParser(ProblemEventHandler problemEventHandler) {
        this((ProblemReporterFactory)new DefaultProblemReporterFactory(problemEventHandler));
    }

    public SmiDefaultParser(ProblemReporterFactory problemReporterFactory) {
        this.m_problemReporterFactory = problemReporterFactory;
    }

    public SmiMib parse() throws SmiException {
        Phase[] phases;
        SmiMib mib = new SmiMib(this.options, new SmiJavaCodeNamingStrategy("org.jsmiparser.mib"));
        for (Phase phase : phases = new Phase[]{this.getFileParserPhase(), this.getXRefPhase(), this.getErrorCheckPhase()}) {
            phase.process(mib);
        }
        if (this.m_failOnError && this.getProblemReporterFactory().getProblemEventHandler().isNotOk()) {
            throw new SmiException();
        }
        return mib;
    }

    public SmiOptions getOptions() {
        return this.options;
    }

    public void setOptions(SmiOptions options) {
        this.options = options;
    }

    protected FileParserPhase createFileParserPhase() {
        return new FileParserPhase((FileParserProblemReporter)this.getProblemReporterFactory().create(FileParserProblemReporter.class));
    }

    protected XRefPhase createXRefPhase() {
        return new XRefPhase((XRefProblemReporter)this.getProblemReporterFactory().create(XRefProblemReporter.class));
    }

    private ErrorCheckPhase createErrorCheckPhase() {
        return new ErrorCheckPhase();
    }

    public ProblemEventHandler getProblemEventHandler() {
        return this.m_problemReporterFactory.getProblemEventHandler();
    }

    public ProblemReporterFactory getProblemReporterFactory() {
        return this.m_problemReporterFactory;
    }

    public void setProblemReporterFactory(ProblemReporterFactory problemReporterFactory) {
        this.m_problemReporterFactory = problemReporterFactory;
    }

    public FileParserPhase getFileParserPhase() {
        if (this.m_fileParserPhase == null) {
            this.m_fileParserPhase = this.createFileParserPhase();
        }
        return this.m_fileParserPhase;
    }

    public void setFileParserPhase(FileParserPhase fileParserPhase) {
        this.m_fileParserPhase = fileParserPhase;
    }

    public XRefPhase getXRefPhase() {
        if (this.m_xRefPhase == null) {
            this.m_xRefPhase = this.createXRefPhase();
        }
        return this.m_xRefPhase;
    }

    public void setXRefPhase(XRefPhase xrefPhase) {
        this.m_xRefPhase = xrefPhase;
    }

    public ErrorCheckPhase getErrorCheckPhase() {
        if (this.m_errorCheckPhase == null) {
            this.m_errorCheckPhase = this.createErrorCheckPhase();
        }
        return this.m_errorCheckPhase;
    }

    public void setErrorCheckPhase(ErrorCheckPhase errorCheckPhase) {
        this.m_errorCheckPhase = errorCheckPhase;
    }

    public boolean isFailOnError() {
        return this.m_failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.m_failOnError = failOnError;
    }
}

