/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.undertow;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.undertow.Undertow;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import java.security.AccessController;
import lombok.Generated;
import org.joinfaces.autoconfigure.undertow.CompositeResourceManager;
import org.joinfaces.autoconfigure.undertow.UndertowProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={UndertowProperties.class})
@ConditionalOnClass(value={Undertow.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class UndertowAutoConfiguration {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UndertowAutoConfiguration.class);

    @Bean
    public WebServerFactoryCustomizer<UndertowServletWebServerFactory> jsfUndertowFactoryCustomizer(UndertowProperties undertowProperties) {
        return factory -> factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> {
            AccessController.doPrivileged(() -> {
                deploymentInfo.setResourceManager((ResourceManager)new CompositeResourceManager(new ResourceManager[]{new ClassPathResourceManager(deploymentInfo.getClassLoader(), undertowProperties.getClassPathResource()), deploymentInfo.getResourceManager()}));
                return null;
            });
            log.info("Setting Undertow classLoader to {} directory", (Object)undertowProperties.getClassPathResource());
        }});
    }
}

