/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.rewrite;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletContext;
import lombok.Generated;
import org.joinfaces.autoconfigure.ClasspathScanUtil;
import org.joinfaces.autoconfigure.rewrite.RewriteProperties;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.rewrite.annotation.ClassVisitorImpl;
import org.ocpsoft.rewrite.annotation.spi.AnnotationHandler;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.servlet.config.HttpConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class SpringBootAnnotationConfigProvider
extends HttpConfigurationProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringBootAnnotationConfigProvider.class);
    private final RewriteProperties.AnnotationConfigProviderProperties properties;

    @Nullable
    public Configuration getConfiguration(ServletContext servletContext) {
        if (!this.properties.isEnabled()) {
            return null;
        }
        LinkedHashSet<Class> ruleAnnotations = new LinkedHashSet<Class>();
        ArrayList<AnnotationHandler> annotationHandlers = new ArrayList<AnnotationHandler>();
        for (AnnotationHandler handler : ServiceLoader.load(AnnotationHandler.class)) {
            annotationHandlers.add(handler);
            ruleAnnotations.add(handler.handles());
        }
        ClassVisitorImpl ruleBuilderVisitor = new ClassVisitorImpl(annotationHandlers, (Object)servletContext);
        Set scanResult = this.findPreparedScanResult(servletContext.getClassLoader()).orElseGet(() -> this.scanClasses(ruleAnnotations));
        scanResult.forEach(arg_0 -> ((ClassVisitorImpl)ruleBuilderVisitor).visit(arg_0));
        return ruleBuilderVisitor;
    }

    public int priority() {
        return 100;
    }

    private Set<Class<?>> scanClasses(Set<Class<? extends Annotation>> supportedAnnotations) {
        LinkedHashSet result = new LinkedHashSet();
        ClassGraph classGraph = new ClassGraph().enableAllInfo().enableExternalClasses();
        List<String> basePackages = this.properties.getBasePackages();
        if (basePackages != null && !basePackages.isEmpty()) {
            classGraph = classGraph.whitelistPackages(basePackages.toArray(new String[0]));
        }
        try (ScanResult scanResult = classGraph.scan();){
            for (Class<? extends Annotation> supportedAnnotation : supportedAnnotations) {
                result.addAll(scanResult.getClassesWithAnnotation(supportedAnnotation.getName()).loadClasses(true));
                result.addAll(scanResult.getClassesWithMethodAnnotation(supportedAnnotation.getName()).loadClasses(true));
                result.addAll(scanResult.getClassesWithFieldAnnotation(supportedAnnotation.getName()).loadClasses(true));
            }
        }
        return result;
    }

    private Optional<Set<Class<?>>> findPreparedScanResult(ClassLoader classLoader) {
        String resourceName = "META-INF/joinfaces/" + AnnotationHandler.class.getName() + ".classes";
        return ClasspathScanUtil.readClassSet(resourceName, classLoader);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SpringBootAnnotationConfigProvider(RewriteProperties.AnnotationConfigProviderProperties properties) {
        this.properties = properties;
    }
}

