/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.jpa;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMoleculesJpa {
    private static final Logger log = LoggerFactory.getLogger(JMoleculesJpa.class);
    private static Map<Class<?>, Collection<Field>> fields = new ConcurrentHashMap();

    public static void verifyNullability(@This Object object) {
        if (object == null) {
            return;
        }
        log.debug("Verifying nullability of {}!", (Object)object.getClass().getSimpleName());
        fields.computeIfAbsent(object.getClass(), JMoleculesJpa::fieldsToNullCheckFor).forEach(it -> {
            Object value;
            try {
                value = it.get(object);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (value == null) {
                throw new IllegalStateException(String.format("%s.%s must not be null!", it.getDeclaringClass().getSimpleName(), it.getName()));
            }
        });
    }

    @Advice.OnMethodExit
    public static void adviceVerifyNullability(@Advice.This Object object) {
        JMoleculesJpa.verifyNullability(object);
    }

    private static Collection<Field> fieldsToNullCheckFor(Class<?> type) {
        return Arrays.stream(type.getDeclaredFields()).filter(field -> !JMoleculesJpa.isGeneratedValue(field)).filter(field -> !JMoleculesJpa.isNullable(field)).peek(field -> field.setAccessible(true)).collect(Collectors.toSet());
    }

    private static boolean isGeneratedValue(Field field) {
        return Arrays.stream(field.getAnnotations()).map(Annotation::annotationType).map(Class::getName).filter(it -> it.endsWith("GeneratedValue")).filter(it -> it.startsWith("javax.persistence") || it.startsWith("jakarta.persistence")).findAny().isPresent();
    }

    private static boolean hasAnnotation(Field field, String simpleName) {
        return Arrays.stream(field.getAnnotations()).anyMatch(it -> it.annotationType().getSimpleName().equals(simpleName));
    }

    private static boolean isNullable(Field field) {
        if (JMoleculesJpa.hasAnnotation(field, "Nullable")) {
            return true;
        }
        return !Arrays.stream(field.getDeclaringClass().getPackage().getAnnotations()).anyMatch(it -> it.annotationType().getSimpleName().equals("NonNullApi"));
    }
}

