/*
 * Decompiled with CFR 0.152.
 */
package org.jline.script;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jline.utils.Log;

public class JrtJavaBasePackages {
    public static List<Object> getClassesForPackage(String pckgname) {
        FileVisitor fv;
        block7: {
            FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
            ArrayList<String> dirs = new ArrayList<String>();
            dirs.add("java.base");
            boolean nestedClasses = true;
            boolean onlyCurrent = false;
            if (pckgname.endsWith(".*")) {
                onlyCurrent = true;
                nestedClasses = false;
                pckgname = pckgname.substring(0, pckgname.length() - 2);
            } else if (pckgname.endsWith(".**")) {
                onlyCurrent = true;
                pckgname = pckgname.substring(0, pckgname.length() - 3);
            }
            dirs.addAll(Arrays.asList(pckgname.split("\\.")));
            Path path = fs.getPath("modules", dirs.toArray(new String[0]));
            fv = new FileVisitor(pckgname, nestedClasses);
            try {
                if (onlyCurrent) {
                    Files.walkFileTree(path, new HashSet<FileVisitOption>(), 1, fv);
                } else {
                    Files.walkFileTree(path, fv);
                }
            }
            catch (IOException e) {
                if (!Log.isDebugEnabled()) break block7;
                e.printStackTrace();
            }
        }
        return fv.getClasses();
    }

    private static class FileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<Object> classes = new ArrayList<Object>();
        private final boolean nestedClasses;
        private final String pckgname;

        public FileVisitor(String pckgname, boolean nestedClasses) {
            this.pckgname = pckgname;
            this.nestedClasses = nestedClasses;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            block5: {
                try {
                    String name = file.toString().substring(18);
                    if (name.endsWith(".class") && (this.nestedClasses || !name.contains("$"))) {
                        String className = name.substring(0, name.length() - 6).replaceAll("/", ".");
                        if (Character.isUpperCase(className.charAt(this.pckgname.length() + 1))) {
                            this.classes.add(Class.forName(className));
                        } else {
                            this.classes.add(className);
                        }
                    }
                }
                catch (Error | Exception e) {
                    if (!Log.isDebugEnabled()) break block5;
                    e.printStackTrace();
                }
            }
            return FileVisitResult.CONTINUE;
        }

        private List<Object> getClasses() {
            return this.classes;
        }
    }
}

