/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.generator;

import java.util.HashMap;
import java.util.Map;
import org.jibx.custom.classes.IDocumentFormatter;
import org.jibx.custom.classes.SharedNestingBase;
import org.jibx.util.IClassLocator;

public class FormatterCache {
    private final IClassLocator m_locator;
    private final Map m_classInstances;

    public FormatterCache(IClassLocator loc) {
        this.m_locator = loc;
        this.m_classInstances = new HashMap();
    }

    public IDocumentFormatter getFormatter(SharedNestingBase custom) {
        String cname = custom.getFormatterClass();
        IDocumentFormatter format = (IDocumentFormatter)this.m_classInstances.get(cname);
        if (format == null) {
            Class clas = this.m_locator.loadClass(cname);
            if (clas == null) {
                throw new IllegalStateException("Cannot load document formatter class " + cname);
            }
            try {
                Object inst = clas.newInstance();
                if (!(inst instanceof IDocumentFormatter)) {
                    throw new IllegalStateException("Specified document formatter class does not implement IDocumentFormatter interface: " + cname);
                }
                this.m_classInstances.put(cname, inst);
                format = (IDocumentFormatter)inst;
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Cannot create instance of document formatter class " + cname);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot access document formatter class " + cname);
            }
        }
        return format;
    }
}

