/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.generator;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jibx.custom.classes.IDocumentFormatter;
import org.jibx.util.IClass;
import org.jibx.util.IClassItem;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DocumentFormatter
implements IDocumentFormatter {
    private final Document m_document;

    public DocumentFormatter() {
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            this.m_document = fact.newDocumentBuilder().newDocument();
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: unable to create DOM builder", e);
        }
    }

    protected Node reformDocSegment(String jdoc) {
        StringBuffer buff = new StringBuffer(jdoc);
        int index = 0;
        boolean dirty = false;
        while (index < buff.length()) {
            char chr = buff.charAt(index);
            if (chr < ' ') {
                if (chr == '\n' || chr == '\r') {
                    if (index > 0 && buff.charAt(index) == ' ' || index + 1 < buff.length() && buff.charAt(index + 1) == ' ') {
                        buff.deleteCharAt(index);
                        continue;
                    }
                    buff.setCharAt(index, ' ');
                    continue;
                }
                buff.deleteCharAt(index);
                continue;
            }
            dirty = dirty || chr == '&' || chr == '<';
            ++index;
        }
        String text = buff.toString();
        if (dirty) {
            return this.m_document.createCDATASection(text);
        }
        return this.m_document.createTextNode(text);
    }

    @Override
    public List docToNodes(String jdoc) {
        if (jdoc != null && (jdoc = jdoc.trim()).length() > 0) {
            boolean dirty;
            ArrayList<Node> nodes = new ArrayList<Node>();
            boolean bl = dirty = jdoc.indexOf(60) >= 0;
            if (dirty) {
                int split;
                String ldoc = jdoc.toLowerCase();
                int base = 0;
                while ((split = ldoc.indexOf("<pre>", base)) > 0) {
                    int end;
                    if (split > base) {
                        nodes.add(this.reformDocSegment(jdoc.substring(base, split)));
                    }
                    if ((end = ldoc.lastIndexOf("</pre>")) < 0) {
                        end = ldoc.length();
                    }
                    nodes.add(this.reformDocSegment(jdoc.substring(split, end)));
                    base = end + 1;
                }
                if (base < jdoc.length()) {
                    nodes.add(this.reformDocSegment(jdoc.substring(base)));
                }
            } else {
                nodes.add(this.reformDocSegment(jdoc));
            }
            return nodes;
        }
        return null;
    }

    @Override
    public List getClassDocumentation(IClass info) {
        return this.docToNodes(info.getJavaDoc());
    }

    @Override
    public List getItemDocumentation(IClassItem info) {
        return this.docToNodes(info.getJavaDoc());
    }
}

