/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.math;

public class NumericsUtilities {
    private static double MACHINE_D_EPSILON;
    private static float MACHINE_F_EPSILON;
    private static final double D_TOLERANCE;
    private static final float F_TOLERANCE;

    public static double getMachineDEpsilon() {
        return MACHINE_D_EPSILON;
    }

    public static float machineFEpsilon() {
        return MACHINE_F_EPSILON;
    }

    public static boolean dEq(double a, double b) {
        if (Double.isNaN(a) && Double.isNaN(b)) {
            return true;
        }
        double diffAbs = Math.abs(a - b);
        return a == b ? true : (diffAbs < D_TOLERANCE ? true : diffAbs / Math.max(Math.abs(a), Math.abs(b)) < D_TOLERANCE);
    }

    public static boolean dEq(double a, double b, double epsilon) {
        if (Double.isNaN(a) && Double.isNaN(b)) {
            return true;
        }
        double diffAbs = Math.abs(a - b);
        return a == b ? true : (diffAbs < epsilon ? true : diffAbs / Math.max(Math.abs(a), Math.abs(b)) < epsilon);
    }

    public static boolean fEq(float a, float b) {
        if (Float.isNaN(a) && Float.isNaN(b)) {
            return true;
        }
        float diffAbs = Math.abs(a - b);
        return a == b ? true : (diffAbs < F_TOLERANCE ? true : diffAbs / Math.max(Math.abs(a), Math.abs(b)) < F_TOLERANCE);
    }

    public static boolean fEq(float a, float b, float epsilon) {
        if (Float.isNaN(a) && Float.isNaN(b)) {
            return true;
        }
        float diffAbs = Math.abs(a - b);
        return a == b ? true : (diffAbs < epsilon ? true : diffAbs / Math.max(Math.abs(a), Math.abs(b)) < epsilon);
    }

    public static <T extends Number> T isNumber(String value, Class<T> adaptee) {
        if (value == null) {
            return null;
        }
        if (adaptee == null || adaptee.isAssignableFrom(Double.class)) {
            try {
                Double parsed = Double.parseDouble(value);
                return (T)((Number)adaptee.cast(parsed));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (adaptee.isAssignableFrom(Float.class)) {
            try {
                Float parsed = Float.valueOf(Float.parseFloat(value));
                return (T)((Number)adaptee.cast(parsed));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (adaptee.isAssignableFrom(Integer.class)) {
            try {
                Integer parsed = Integer.parseInt(value);
                return (T)((Number)adaptee.cast(parsed));
            }
            catch (Exception e) {
                try {
                    Integer parsed = (int)Double.parseDouble(value);
                    return (T)((Number)adaptee.cast(parsed));
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public static double pythagoras(double d1, double d2) {
        return Math.sqrt(Math.pow(d1, 2.0) + Math.pow(d2, 2.0));
    }

    public static boolean isBetween(double value, double ... ranges) {
        boolean even = true;
        for (int i = 0; i < ranges.length; ++i) {
            if (even ? value < ranges[i] : value > ranges[i]) {
                return false;
            }
            even = !even;
        }
        return true;
    }

    static {
        float fTmp = 0.5f;
        double dTmp = 0.5;
        while (1.0f + fTmp > 1.0f) {
            fTmp /= 2.0f;
        }
        while (1.0 + dTmp > 1.0) {
            dTmp /= 2.0;
        }
        MACHINE_D_EPSILON = dTmp;
        MACHINE_F_EPSILON = fTmp;
        D_TOLERANCE = MACHINE_D_EPSILON * 10.0;
        F_TOLERANCE = MACHINE_F_EPSILON * 10.0f;
    }
}

