/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.math;

import java.awt.image.RenderedImage;
import org.jgrasstools.gears.i18n.GearsMessageHandler;
import org.jgrasstools.gears.libs.modules.ModelsEngine;
import org.jgrasstools.gears.libs.modules.SplitVectors;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.utils.sorting.QuickSortAlgorithm;

public class CoupledFieldsMoments {
    public double[][] process(RenderedImage map1RI, RenderedImage map2RI, int pBins, int pFirst, int pLast, IJGTProgressMonitor pm, int binmode) {
        if (map2RI == null) {
            map2RI = map1RI;
        }
        GearsMessageHandler msg = GearsMessageHandler.getInstance();
        pm.message(msg.message("cb.vectorize"));
        double[] U = ModelsEngine.vectorizeDoubleMatrix(map1RI);
        double[] T = null;
        QuickSortAlgorithm t = new QuickSortAlgorithm(pm);
        if (map2RI == null) {
            T = U;
            t.sort(U, null);
        } else {
            T = ModelsEngine.vectorizeDoubleMatrix(map2RI);
            t.sort(U, T);
        }
        SplitVectors theSplit = new SplitVectors();
        int num_max = 1000;
        pm.message(msg.message("cb.splitvector"));
        ModelsEngine.split2realvectors(U, T, theSplit, pBins, num_max, pm);
        pm.message(msg.message("cb.creatematrix"));
        double[][] outCb = new double[theSplit.splitIndex.length][pLast - pFirst + 3];
        binmode = 1;
        if (binmode == 1) {
            for (int h = 0; h < theSplit.splitIndex.length; ++h) {
                outCb[h][0] = ModelsEngine.doubleNMoment(theSplit.splitValues1[h], (int)theSplit.splitIndex[h], 0.0, 1.0, pm);
                outCb[h][1] = theSplit.splitIndex[h];
                outCb[h][2] = ModelsEngine.doubleNMoment(theSplit.splitValues2[h], (int)theSplit.splitIndex[h], 0.0, 1.0, pm);
                if (pFirst == 1) {
                    // empty if block
                }
                for (int k = ++pFirst; k <= pLast; ++k) {
                    outCb[h][k - pFirst + 3] = ModelsEngine.doubleNMoment(theSplit.splitValues2[h], (int)theSplit.splitIndex[h], outCb[h][1], k, pm);
                }
            }
        }
        return outCb;
    }
}

