/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.geometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import org.geotools.referencing.GeodeticCalculator;
import org.jgrasstools.gears.utils.math.NumericsUtilities;
import org.opengis.feature.type.GeometryType;

public class GeometryUtilities {
    private static GeometryFactory geomFactory;
    private static PrecisionModel precModel;

    public static PrecisionModel basicPrecisionModel() {
        return GeometryUtilities.pm();
    }

    public static GeometryFactory gf() {
        if (geomFactory == null) {
            geomFactory = new GeometryFactory();
        }
        return geomFactory;
    }

    public static PrecisionModel pm() {
        if (precModel == null) {
            precModel = new PrecisionModel();
        }
        return precModel;
    }

    public static Polygon createSimplePolygon(Coordinate[] coords) {
        LinearRing linearRing = GeometryUtilities.gf().createLinearRing(coords);
        return GeometryUtilities.gf().createPolygon(linearRing, null);
    }

    public static Polygon createDummyPolygon() {
        Coordinate[] c = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(1.0, 0.0), new Coordinate(0.0, 0.0)};
        LinearRing linearRing = GeometryUtilities.gf().createLinearRing(c);
        return GeometryUtilities.gf().createPolygon(linearRing, null);
    }

    public static Polygon createPolygonFromEnvelope(Envelope env) {
        Coordinate[] c = new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMinY())};
        LinearRing linearRing = GeometryUtilities.gf().createLinearRing(c);
        return GeometryUtilities.gf().createPolygon(linearRing, null);
    }

    public static double angleBetween(LineSegment l1, LineSegment l2) {
        double tol = 1.0E-5;
        double s1 = (l1.p1.y - l1.p0.y) / (l1.p1.x - l1.p0.x);
        double s2 = (l2.p1.y - l2.p0.y) / (l2.p1.x - l2.p0.x);
        if (Math.abs(s1 - s2) < tol) {
            return 0.0;
        }
        if (Math.abs(s1 + s2) < tol) {
            return Math.PI;
        }
        LineSegment tls1 = new LineSegment(new Coordinate(0.0, 0.0), new Coordinate(l1.p1.x - l1.p0.x, l1.p1.y - l1.p0.y));
        LineSegment tls2 = new LineSegment(new Coordinate(0.0, 0.0), new Coordinate(l2.p1.x - l2.p0.x, l2.p1.y - l2.p0.y));
        LineSegment ls3 = new LineSegment(tls1.p1, tls2.p1);
        double c = ls3.getLength();
        double a = tls1.getLength();
        double b = tls2.getLength();
        return Math.toDegrees(Math.acos((a * a + b * b - c * c) / (2.0 * a * b)));
    }

    public static double azimuth(Coordinate c1, Coordinate c2) {
        if (c1.x == c2.x) {
            if (c1.y == c2.y) {
                return Double.NaN;
            }
            if (c1.y < c2.y) {
                return 0.0;
            }
            if (c1.y > c2.y) {
                return 180.0;
            }
        }
        if (c1.y == c2.y) {
            if (c1.x < c2.x) {
                return 90.0;
            }
            if (c1.x > c2.x) {
                return 270.0;
            }
        }
        if (c1.x < c2.x && c1.y < c2.y) {
            double tanA = (c2.x - c1.x) / (c2.y - c1.y);
            double atan = Math.atan(tanA);
            return Math.toDegrees(atan);
        }
        if (c1.x < c2.x && c1.y > c2.y) {
            double tanA = (c1.y - c2.y) / (c2.x - c1.x);
            double atan = Math.atan(tanA);
            return Math.toDegrees(atan) + 90.0;
        }
        if (c1.x > c2.x && c1.y > c2.y) {
            double tanA = (c1.x - c2.x) / (c1.y - c2.y);
            double atan = Math.atan(tanA);
            return Math.toDegrees(atan) + 180.0;
        }
        if (c1.x > c2.x && c1.y < c2.y) {
            double tanA = (c2.y - c1.y) / (c1.x - c2.x);
            double atan = Math.atan(tanA);
            return Math.toDegrees(atan) + 270.0;
        }
        return Double.NaN;
    }

    public static GEOMETRYTYPE getGeometryType(Geometry geometry) {
        if (geometry instanceof LineString) {
            return GEOMETRYTYPE.LINE;
        }
        if (geometry instanceof MultiLineString) {
            return GEOMETRYTYPE.MULTILINE;
        }
        if (geometry instanceof Point) {
            return GEOMETRYTYPE.POINT;
        }
        if (geometry instanceof MultiPoint) {
            return GEOMETRYTYPE.MULTIPOINT;
        }
        if (geometry instanceof Polygon) {
            return GEOMETRYTYPE.POLYGON;
        }
        if (geometry instanceof MultiPolygon) {
            return GEOMETRYTYPE.MULTIPOLYGON;
        }
        return null;
    }

    public static GEOMETRYTYPE getGeometryType(GeometryType geometryType) {
        Class binding = geometryType.getBinding();
        if (binding == LineString.class) {
            return GEOMETRYTYPE.LINE;
        }
        if (binding == MultiLineString.class) {
            return GEOMETRYTYPE.MULTILINE;
        }
        if (binding == Point.class) {
            return GEOMETRYTYPE.POINT;
        }
        if (binding == MultiPoint.class) {
            return GEOMETRYTYPE.MULTIPOINT;
        }
        if (binding == Polygon.class) {
            return GEOMETRYTYPE.POLYGON;
        }
        if (binding == MultiPolygon.class) {
            return GEOMETRYTYPE.MULTIPOLYGON;
        }
        return null;
    }

    public static boolean isLine(Geometry geometry) {
        return geometry instanceof LineString || geometry instanceof MultiLineString;
    }

    public static boolean isPolygon(Geometry geometry) {
        return geometry instanceof Polygon || geometry instanceof MultiPolygon;
    }

    public static boolean isPoint(Geometry geometry) {
        return geometry instanceof Point || geometry instanceof MultiPoint;
    }

    public static double getPolygonArea(int[] x, int[] y, int N) {
        double area = 0.0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            area += (double)(x[i] * y[j]);
            area -= (double)(y[i] * x[j]);
        }
        return (area /= 2.0) < 0.0 ? -area : area;
    }

    public static double distance3d(Coordinate c1, Coordinate c2, GeodeticCalculator geodeticCalculator) {
        double projectedDistance;
        if (Double.isNaN(c1.z) || Double.isNaN(c2.z)) {
            throw new IllegalArgumentException("Missing elevation information in the supplied coordinates.");
        }
        double deltaElev = Math.abs(c1.z - c2.z);
        if (geodeticCalculator != null) {
            geodeticCalculator.setStartingGeographicPoint(c1.x, c1.y);
            geodeticCalculator.setDestinationGeographicPoint(c2.x, c2.y);
            projectedDistance = geodeticCalculator.getOrthodromicDistance();
        } else {
            projectedDistance = c1.distance(c2);
        }
        double distance = NumericsUtilities.pythagoras(projectedDistance, deltaElev);
        return distance;
    }

    public static enum GEOMETRYTYPE {
        POINT,
        MULTIPOINT,
        LINE,
        MULTILINE,
        POLYGON,
        MULTIPOLYGON,
        UNKNOWN;

    }
}

