/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.files;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class FileUtilities {
    public static void copyFile(String fromFile, String toFile) throws IOException {
        File in = new File(fromFile);
        File out = new File(toFile);
        FileUtilities.copyFile(in, out);
    }

    public static void copyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public static boolean deleteFileOrDir(File filehandle) {
        boolean isdel;
        if (filehandle.isDirectory()) {
            String[] children = filehandle.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtilities.deleteFileOrDir(new File(filehandle, children[i]));
                if (success) continue;
                return false;
            }
        }
        if (!(isdel = filehandle.delete())) {
            filehandle.deleteOnExit();
        }
        return isdel;
    }

    public static boolean deleteFileOrDirOnExit(File filehandle) {
        if (filehandle.isDirectory()) {
            String[] children = filehandle.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtilities.deleteFileOrDir(new File(filehandle, children[i]));
                if (success) continue;
                return false;
            }
        }
        filehandle.deleteOnExit();
        return true;
    }

    public static String readInputStreamToString(InputStream inputStream) throws IOException {
        ArrayList<Byte> bytesList = new ArrayList<Byte>();
        byte b = 0;
        while ((b = (byte)inputStream.read()) != -1) {
            bytesList.add(b);
        }
        inputStream.close();
        byte[] bArray = new byte[bytesList.size()];
        for (int i = 0; i < bArray.length; ++i) {
            bArray[i] = (Byte)bytesList.get(i);
        }
        String file = new String(bArray);
        return file;
    }

    public static String readFile(String filePath) throws IOException {
        return FileUtilities.readFile(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder(200);
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            br.close();
        }
    }

    public static List<String> readFileToLinesList(String filePath) throws IOException {
        return FileUtilities.readFileToLinesList(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFileToLinesList(File file) throws IOException {
        BufferedReader br = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            br = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        finally {
            br.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String text, File file) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file));
            bw.write(text);
        }
        finally {
            bw.close();
        }
    }

    public static void writeFile(List<String> lines, String filePath) throws IOException {
        FileUtilities.writeFile(lines, new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(List<String> lines, File file) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file));
            for (String line : lines) {
                bw.write(line);
                bw.write("\n");
            }
        }
        finally {
            bw.close();
        }
    }

    public static String replaceBackSlashes(String path) {
        return path.replaceAll("\\\\", "\\\\\\\\");
    }

    public static String getNameWithoutExtention(File file) {
        String name = file.getName();
        int lastDot = name.lastIndexOf(".");
        name = name.substring(0, lastDot);
        return name;
    }

    public static File substituteExtention(File file, String newExtention) {
        String path = file.getAbsolutePath();
        int lastDot = path.lastIndexOf(".");
        path = path.substring(0, lastDot) + "." + newExtention;
        return new File(path);
    }
}

