/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.features;

import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;

public class FilterUtilities {
    public static Filter getBboxFilter(String attribute, BoundingBox bbox) throws CQLException {
        double w = bbox.getMinX();
        double e = bbox.getMaxX();
        double s = bbox.getMinY();
        double n = bbox.getMaxY();
        return FilterUtilities.getBboxFilter(attribute, w, e, s, n);
    }

    public static Filter getBboxFilter(String attribute, double west, double east, double south, double north) throws CQLException {
        if (attribute == null) {
            attribute = "the_geom";
        }
        StringBuilder sB = new StringBuilder();
        sB.append("BBOX(");
        sB.append(attribute);
        sB.append(",");
        sB.append(west);
        sB.append(",");
        sB.append(south);
        sB.append(",");
        sB.append(east);
        sB.append(",");
        sB.append(north);
        sB.append(")");
        Filter bboxFilter = CQL.toFilter((String)sB.toString());
        return bboxFilter;
    }

    public static Filter getCQLFilter(String expression) throws CQLException {
        Filter cqlFilter = ECQL.toFilter((String)expression);
        return cqlFilter;
    }
}

