/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.features;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.grassraster.JGrassConstants;
import org.geotools.geometry.Envelope2D;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.utils.features.FeatureMate;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureUtilities {
    public static CoordinateList orderLineGeometries(List<Geometry> geometryList, double thresHold) {
        int i;
        Geometry firstFeature = null;
        boolean foundFirst = true;
        boolean foundSecond = true;
        for (Geometry feature : geometryList) {
            foundFirst = true;
            foundSecond = true;
            Coordinate[] coords = feature.getCoordinates();
            Coordinate first = coords[0];
            Coordinate last = coords[coords.length - 1];
            for (Geometry compareFeature : geometryList) {
                if (compareFeature.equals(feature)) continue;
                Coordinate[] compareCoords = compareFeature.getCoordinates();
                Coordinate comparefirst = compareCoords[0];
                Coordinate comparelast = compareCoords[compareCoords.length - 1];
                if (first.distance(comparefirst) < thresHold || first.distance(comparelast) < thresHold) {
                    foundFirst = false;
                }
                if (!(last.distance(comparefirst) < thresHold) && !(last.distance(comparelast) < thresHold)) continue;
                foundSecond = false;
            }
            if (!foundFirst && !foundSecond) continue;
            firstFeature = feature;
            break;
        }
        if (firstFeature == null) {
            throw new RuntimeException();
        }
        CoordinateList coordinateList = new CoordinateList();
        Coordinate[] coords = firstFeature.getCoordinates();
        if (foundSecond) {
            for (i = 0; i < coords.length; ++i) {
                coordinateList.add((Object)coords[coords.length - i - 1]);
            }
        } else {
            for (i = 0; i < coords.length; ++i) {
                coordinateList.add((Object)coords[i]);
            }
        }
        geometryList.remove(firstFeature);
        Coordinate currentCoordinate = coordinateList.getCoordinate(coordinateList.size() - 1);
        block4: while (geometryList.size() != 0) {
            for (int j = 0; j < geometryList.size(); ++j) {
                int i2;
                System.out.println(j);
                Geometry compareGeom = geometryList.get(j);
                Coordinate[] compareCoords = compareGeom.getCoordinates();
                Coordinate comparefirst = compareCoords[0];
                Coordinate comparelast = compareCoords[compareCoords.length - 1];
                if (currentCoordinate.distance(comparefirst) < thresHold) {
                    for (i2 = 0; i2 < compareCoords.length; ++i2) {
                        coordinateList.add((Object)compareCoords[i2]);
                    }
                    currentCoordinate = new Coordinate(comparelast);
                    geometryList.remove(compareGeom);
                    continue block4;
                }
                if (!(currentCoordinate.distance(comparelast) < thresHold)) continue;
                for (i2 = 0; i2 < compareCoords.length; ++i2) {
                    coordinateList.add((Object)compareCoords[compareCoords.length - i2 - 1]);
                }
                currentCoordinate = new Coordinate(comparefirst);
                geometryList.remove(compareGeom);
                continue block4;
            }
        }
        return coordinateList;
    }

    public static SimpleFeatureCollection createFeatureCollection(SimpleFeature ... features) {
        SimpleFeatureCollection fcollection = FeatureCollections.newCollection();
        for (SimpleFeature feature : features) {
            fcollection.add((Feature)feature);
        }
        return fcollection;
    }

    public static SimpleFeatureCollection csvFileToFeatureCollection(File csvFile, CoordinateReferenceSystem crs, LinkedHashMap<String, Integer> fieldsAndTypesIndex, String separator, IJGTProgressMonitor pm) throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Map typesMap = JGrassConstants.CSVTYPESCLASSESMAP;
        String[] typesArray = JGrassConstants.CSVTYPESARRAY;
        if (separator == null) {
            separator = ",";
        }
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("csvimport");
        b.setCRS(crs);
        b.add("the_geom", Point.class);
        int xIndex = -1;
        int yIndex = -1;
        Set<String> fieldNames = fieldsAndTypesIndex.keySet();
        String[] fieldNamesArray = fieldNames.toArray(new String[fieldNames.size()]);
        for (int i = 0; i < fieldNamesArray.length; ++i) {
            String fieldName = fieldNamesArray[i];
            Integer typeIndex = fieldsAndTypesIndex.get(fieldName);
            if (typeIndex == 0) {
                xIndex = i;
                continue;
            }
            if (typeIndex == 1) {
                yIndex = i;
                continue;
            }
            Class class1 = (Class)typesMap.get(typesArray[typeIndex]);
            b.add(fieldName, class1);
        }
        SimpleFeatureType featureType = b.buildFeatureType();
        SimpleFeatureCollection newCollection = FeatureCollections.newCollection();
        Collection<Integer> orderedTypeIndexes = fieldsAndTypesIndex.values();
        Integer[] orderedTypeIndexesArray = orderedTypeIndexes.toArray(new Integer[orderedTypeIndexes.size()]);
        BufferedReader bR = new BufferedReader(new FileReader(csvFile));
        String line = null;
        int featureId = 0;
        pm.beginTask("Importing raw data", -1);
        while ((line = bR.readLine()) != null) {
            pm.worked(1);
            if (line.startsWith("#")) continue;
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
            Object[] values = new Object[fieldNames.size() - 1];
            String[] lineSplit = line.split(separator);
            double x = Double.parseDouble(lineSplit[xIndex]);
            double y = Double.parseDouble(lineSplit[yIndex]);
            Point point = gf.createPoint(new Coordinate(x, y));
            values[0] = point;
            int objIndex = 1;
            for (int i = 0; i < lineSplit.length; ++i) {
                if (i == xIndex || i == yIndex) continue;
                String value = lineSplit[i];
                int typeIndex = orderedTypeIndexesArray[i];
                String typeName = typesArray[typeIndex];
                if (typeName.equals(typesArray[3])) {
                    values[objIndex] = value;
                } else if (typeName.equals(typesArray[4])) {
                    values[objIndex] = new Double(value);
                } else if (typeName.equals(typesArray[5])) {
                    values[objIndex] = new Integer(value);
                } else {
                    throw new IllegalArgumentException("An undefined value type was found");
                }
                ++objIndex;
            }
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(featureType.getTypeName() + "." + featureId);
            ++featureId;
            newCollection.add((Feature)feature);
        }
        bR.close();
        pm.done();
        return newCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean collectionToShapeFile(String shapeFilePath, CoordinateReferenceSystem crs, SimpleFeatureCollection fet) throws IOException {
        File file = null;
        file = shapeFilePath.toLowerCase().endsWith(".shp") ? new File(shapeFilePath) : new File(shapeFilePath + ".shp");
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, URL> create = new HashMap<String, URL>();
        create.put("url", file.toURI().toURL());
        ShapefileDataStore newDataStore = (ShapefileDataStore)factory.createNewDataStore(create);
        newDataStore.createSchema((SimpleFeatureType)fet.getSchema());
        if (crs != null) {
            newDataStore.forceSchemaCRS(crs);
        }
        DefaultTransaction transaction = new DefaultTransaction();
        FeatureStore featureStore = (FeatureStore)newDataStore.getFeatureSource();
        featureStore.setTransaction((Transaction)transaction);
        try {
            featureStore.addFeatures((FeatureCollection)fet);
            transaction.commit();
        }
        catch (Exception problem) {
            problem.printStackTrace();
            transaction.rollback();
        }
        finally {
            transaction.close();
        }
        return true;
    }

    public static synchronized ShapefileDataStore createShapeFileDatastore(String name, String fieldsSpec, CoordinateReferenceSystem crs) throws Exception {
        File file = null;
        file = name.toLowerCase().endsWith(".shp") ? new File(name) : new File(name + ".shp");
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, URL> create = new HashMap<String, URL>();
        create.put("url", file.toURI().toURL());
        ShapefileDataStore myData = (ShapefileDataStore)factory.createNewDataStore(create);
        SimpleFeatureType featureType = DataUtilities.createType((String)name, (String)fieldsSpec);
        myData.createSchema(featureType);
        myData.forceSchemaCRS(crs);
        return myData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean writeToShapefile(ShapefileDataStore data, SimpleFeatureCollection collection) throws IOException {
        String featureName = data.getTypeNames()[0];
        FeatureStore store = null;
        Transaction transaction = null;
        try {
            transaction = Transaction.AUTO_COMMIT;
            SimpleFeatureSource source = data.getFeatureSource(featureName);
            store = (FeatureStore)source;
            store.addFeatures((FeatureCollection)collection);
            data.getFeatureWriter(transaction);
            boolean bl = true;
            return bl;
        }
        catch (Exception eek) {
            eek.printStackTrace();
            transaction.rollback();
            boolean bl = false;
            return bl;
        }
        finally {
            transaction.close();
        }
    }

    public static List<SimpleFeature> featureCollectionToList(SimpleFeatureCollection collection) {
        ArrayList<SimpleFeature> featuresList = new ArrayList<SimpleFeature>();
        if (collection == null) {
            return featuresList;
        }
        SimpleFeatureIterator featureIterator = collection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            featuresList.add(feature);
        }
        featureIterator.close();
        return featuresList;
    }

    public static List<FeatureMate> featureCollectionToMatesList(SimpleFeatureCollection collection) {
        ArrayList<FeatureMate> featuresList = new ArrayList<FeatureMate>();
        if (collection == null) {
            return featuresList;
        }
        SimpleFeatureIterator featureIterator = collection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            featuresList.add(new FeatureMate(feature));
        }
        featureIterator.close();
        return featuresList;
    }

    public static List<Geometry> featureCollectionToGeometriesList(SimpleFeatureCollection collection) {
        ArrayList<Geometry> geometriesList = new ArrayList<Geometry>();
        if (collection == null) {
            return geometriesList;
        }
        SimpleFeatureIterator featureIterator = collection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            geometriesList.add(geometry);
        }
        featureIterator.close();
        return geometriesList;
    }

    public static Object getAttributeCaseChecked(SimpleFeature feature, String field) {
        Object attribute = feature.getAttribute(field);
        if (attribute == null) {
            attribute = feature.getAttribute(field.toLowerCase());
            if (attribute != null) {
                return attribute;
            }
            attribute = feature.getAttribute(field.toUpperCase());
            if (attribute != null) {
                return attribute;
            }
            SimpleFeatureType featureType = feature.getFeatureType();
            field = FeatureUtilities.findAttributeName(featureType, field);
            if (field != null) {
                return feature.getAttribute(field);
            }
        }
        return attribute;
    }

    public static String findAttributeName(SimpleFeatureType featureType, String field) {
        List attributeDescriptors = featureType.getAttributeDescriptors();
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            String name = attributeDescriptor.getLocalName();
            if (!name.toLowerCase().equals(field.toLowerCase())) continue;
            return name;
        }
        return null;
    }

    public static Polygon envelopeToPolygon(Envelope2D envelope) {
        double w = envelope.getMinX();
        double e = envelope.getMaxX();
        double s = envelope.getMinY();
        double n = envelope.getMaxY();
        Coordinate[] coords = new Coordinate[]{new Coordinate(w, n), new Coordinate(e, n), new Coordinate(e, s), new Coordinate(w, s), new Coordinate(w, n)};
        GeometryFactory gf = GeometryUtilities.gf();
        LinearRing linearRing = gf.createLinearRing(coords);
        Polygon polygon = gf.createPolygon(linearRing, null);
        return polygon;
    }
}

