/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.coverage;

import com.vividsolutions.jts.geom.Coordinate;
import org.jgrasstools.gears.utils.math.NumericsUtilities;

public class ProfilePoint
implements Comparable<ProfilePoint> {
    private double progressive;
    private double elevation;
    private Coordinate position;

    public ProfilePoint(double progressive, double elevation, Coordinate position) {
        this.progressive = progressive;
        this.elevation = elevation;
        this.position = position;
    }

    public ProfilePoint(double progressive, double elevation, double easting, double northing) {
        this.progressive = progressive;
        this.elevation = elevation;
        this.position = new Coordinate(easting, northing);
    }

    public double getProgressive() {
        return this.progressive;
    }

    public double getElevation() {
        return this.elevation;
    }

    public Coordinate getPosition() {
        return this.position;
    }

    @Override
    public int compareTo(ProfilePoint o) {
        if (NumericsUtilities.dEq(this.progressive, o.progressive)) {
            return 0;
        }
        if (this.progressive > o.progressive) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return this.progressive + ", " + this.elevation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.elevation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        temp = Double.doubleToLongBits(this.progressive);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfilePoint other = (ProfilePoint)obj;
        Coordinate otherPosition = other.position;
        return NumericsUtilities.dEq(this.elevation, other.elevation) && NumericsUtilities.dEq(this.position.x, otherPosition.x) && NumericsUtilities.dEq(this.position.y, otherPosition.y);
    }
}

