/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.coverage;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterFactory;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.jgrasstools.gears.io.grasslegacy.GrassLegacyGridCoverage2D;
import org.jgrasstools.gears.io.grasslegacy.GrassLegacyRandomIter;
import org.jgrasstools.gears.io.grasslegacy.GrassLegacyWritableRaster;
import org.jgrasstools.gears.io.grasslegacy.utils.Window;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.ProfilePoint;
import org.jgrasstools.gears.utils.features.FastLiteShape;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CoverageUtilities {
    public static final String NORTH = "NORTH";
    public static final String SOUTH = "SOUTH";
    public static final String WEST = "WEST";
    public static final String EAST = "EAST";
    public static final String XRES = "XRES";
    public static final String YRES = "YRES";
    public static final String ROWS = "ROWS";
    public static final String COLS = "COLS";

    public static RandomIter getRandomIterator(GridCoverage2D coverage) {
        if (coverage instanceof GrassLegacyGridCoverage2D) {
            GrassLegacyGridCoverage2D grassGC = (GrassLegacyGridCoverage2D)coverage;
            GrassLegacyRandomIter iter = new GrassLegacyRandomIter(grassGC.getData());
            return iter;
        }
        RenderedImage renderedImage = coverage.getRenderedImage();
        RandomIter iter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        return iter;
    }

    public static WritableRandomIter getWritableRandomIterator(int width, int height) {
        if (JGTConstants.doesOverFlow(width, height)) {
            GrassLegacyRandomIter iter = new GrassLegacyRandomIter(new double[height][width]);
            return iter;
        }
        WritableRaster pitRaster = CoverageUtilities.createDoubleWritableRaster(width, height, null, null, null);
        WritableRandomIter iter = RandomIterFactory.createWritable((WritableRaster)pitRaster, null);
        return iter;
    }

    public static WritableRandomIter getWritableRandomIterator(WritableRaster raster) {
        if (raster instanceof GrassLegacyWritableRaster) {
            GrassLegacyWritableRaster wRaster = (GrassLegacyWritableRaster)raster;
            double[][] data = wRaster.getData();
            CoverageUtilities.getWritableRandomIterator(data[0].length, data.length);
        }
        WritableRandomIter iter = RandomIterFactory.createWritable((WritableRaster)raster, null);
        return iter;
    }

    public static WritableRaster createDoubleWritableRaster(int width, int height, Class<?> dataClass, SampleModel sampleModel, Double value) {
        int dataType = 5;
        if (dataClass != null) {
            if (dataClass.isAssignableFrom(Integer.class)) {
                dataType = 3;
            } else if (dataClass.isAssignableFrom(Float.class)) {
                dataType = 4;
            } else if (dataClass.isAssignableFrom(Byte.class)) {
                dataType = 0;
            }
        }
        if (!JGTConstants.doesOverFlow(width, height)) {
            if (sampleModel == null) {
                sampleModel = new ComponentSampleModel(dataType, width, height, 1, width, new int[]{0});
            }
            WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, null);
            if (value != null) {
                double v = value;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        raster.setSample(x, y, 0, v);
                    }
                }
            }
            return raster;
        }
        GrassLegacyWritableRaster raster = new GrassLegacyWritableRaster(new double[height][width]);
        return raster;
    }

    public static RegionMap getRegionParamsFromGridCoverage(GridCoverage2D gridCoverage) {
        RegionMap envelopeParams = new RegionMap();
        Envelope envelope = gridCoverage.getEnvelope();
        DirectPosition lowerCorner = envelope.getLowerCorner();
        double[] westSouth = lowerCorner.getCoordinate();
        DirectPosition upperCorner = envelope.getUpperCorner();
        double[] eastNorth = upperCorner.getCoordinate();
        GridGeometry2D gridGeometry = gridCoverage.getGridGeometry();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int height = gridRange.height;
        int width = gridRange.width;
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double xRes = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
        double yRes = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
        envelopeParams.put(NORTH, eastNorth[1]);
        envelopeParams.put(SOUTH, westSouth[1]);
        envelopeParams.put(WEST, westSouth[0]);
        envelopeParams.put(EAST, eastNorth[0]);
        envelopeParams.put(XRES, xRes);
        envelopeParams.put(YRES, yRes);
        envelopeParams.put(ROWS, Double.valueOf(height));
        envelopeParams.put(COLS, Double.valueOf(width));
        return envelopeParams;
    }

    public static double[] getRegionArrayFromGridCoverage(GridCoverage2D gridCoverage) {
        Envelope envelope = gridCoverage.getEnvelope();
        DirectPosition lowerCorner = envelope.getLowerCorner();
        double[] westSouth = lowerCorner.getCoordinate();
        DirectPosition upperCorner = envelope.getUpperCorner();
        double[] eastNorth = upperCorner.getCoordinate();
        GridGeometry2D gridGeometry = gridCoverage.getGridGeometry();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int height = gridRange.height;
        int width = gridRange.width;
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double xRes = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
        double yRes = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
        double[] params = new double[]{eastNorth[1], westSouth[1], westSouth[0], eastNorth[0], xRes, yRes, width, height};
        return params;
    }

    public static int[] getRegionColsRows(GridCoverage2D gridCoverage) {
        GridGeometry2D gridGeometry = gridCoverage.getGridGeometry();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int height = gridRange.height;
        int width = gridRange.width;
        int[] params = new int[]{width, height};
        return params;
    }

    public static HashMap<String, Double> generalParameterValues2RegionParamsMap(GeneralParameterValue[] params) {
        GridGeometry2D gg = null;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                ParameterValue param = (ParameterValue)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (!name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) continue;
                gg = (GridGeometry2D)param.getValue();
                break;
            }
        }
        if (gg == null) {
            throw new IllegalArgumentException("No gridgeometry present");
        }
        RegionMap regionParams = CoverageUtilities.gridGeometry2RegionParamsMap(gg);
        return regionParams;
    }

    public static RegionMap gridGeometry2RegionParamsMap(GridGeometry2D gridGeometry) {
        RegionMap envelopeParams = new RegionMap();
        Envelope2D envelope = gridGeometry.getEnvelope2D();
        DirectPosition lowerCorner = envelope.getLowerCorner();
        double[] westSouth = lowerCorner.getCoordinate();
        DirectPosition upperCorner = envelope.getUpperCorner();
        double[] eastNorth = upperCorner.getCoordinate();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int height = gridRange.height;
        int width = gridRange.width;
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double xRes = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
        double yRes = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
        envelopeParams.put(NORTH, eastNorth[1]);
        envelopeParams.put(SOUTH, westSouth[1]);
        envelopeParams.put(WEST, westSouth[0]);
        envelopeParams.put(EAST, eastNorth[0]);
        envelopeParams.put(XRES, xRes);
        envelopeParams.put(YRES, yRes);
        envelopeParams.put(ROWS, Double.valueOf(height));
        envelopeParams.put(COLS, Double.valueOf(width));
        return envelopeParams;
    }

    public static RegionMap makeRegionParamsMap(double north, double south, double west, double east, double xRes, double yRes, int width, int height) {
        RegionMap envelopeParams = new RegionMap();
        envelopeParams.put(NORTH, north);
        envelopeParams.put(SOUTH, south);
        envelopeParams.put(WEST, west);
        envelopeParams.put(EAST, east);
        envelopeParams.put(XRES, xRes);
        envelopeParams.put(YRES, yRes);
        envelopeParams.put(ROWS, Double.valueOf(height));
        envelopeParams.put(COLS, Double.valueOf(width));
        return envelopeParams;
    }

    public static GridGeometry2D gridGeometryFromRegionParams(HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs) {
        double west = envelopeParams.get(WEST);
        double south = envelopeParams.get(SOUTH);
        double east = envelopeParams.get(EAST);
        double north = envelopeParams.get(NORTH);
        int rows = envelopeParams.get(ROWS).intValue();
        int cols = envelopeParams.get(COLS).intValue();
        return CoverageUtilities.gridGeometryFromRegionValues(north, south, east, west, cols, rows, crs);
    }

    public static GridGeometry2D gridGeometryFromRegionValues(double north, double south, double east, double west, int cols, int rows, CoordinateReferenceSystem crs) {
        Envelope2D envelope = new Envelope2D(crs, west, south, east - west, north - south);
        GridEnvelope2D gridRange = new GridEnvelope2D(0, 0, cols, rows);
        GridGeometry2D gridGeometry2D = new GridGeometry2D((GridEnvelope)gridRange, (Envelope)envelope);
        return gridGeometry2D;
    }

    public static GeneralParameterValue[] createGridGeometryGeneralParameter(int width, int height, double north, double south, double east, double west, CoordinateReferenceSystem crs) {
        ReferencedEnvelope env;
        GeneralParameterValue[] readParams = new GeneralParameterValue[1];
        Parameter readGG = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
        GridEnvelope2D gridEnvelope = new GridEnvelope2D(0, 0, width, height);
        if (crs != null) {
            env = new ReferencedEnvelope(west, east, south, north, crs);
        } else {
            DirectPosition2D minDp = new DirectPosition2D(west, south);
            DirectPosition2D maxDp = new DirectPosition2D(east, north);
            env = new Envelope2D(minDp, maxDp);
        }
        readGG.setValue((Object)new GridGeometry2D((GridEnvelope)gridEnvelope, (Envelope)env));
        readParams[0] = readGG;
        return readParams;
    }

    public static GeneralParameterValue[] createGridGeometryGeneralParameter(double xres, double yres, double north, double south, double east, double west, CoordinateReferenceSystem crs) {
        int width;
        int height = (int)Math.round((north - south) / yres);
        if (height < 1) {
            height = 1;
        }
        if ((width = (int)Math.round((east - west) / xres)) < 1) {
            width = 1;
        }
        GeneralParameterValue[] generalParameter = CoverageUtilities.createGridGeometryGeneralParameter(width, height, north, south, east, west, crs);
        return generalParameter;
    }

    public static WritableRaster createWritableRasterFromMatrix(double[][] matrix, boolean matrixIsRowCol) {
        int height = matrix.length;
        int width = matrix[0].length;
        if (!matrixIsRowCol) {
            int tmp = height;
            height = width;
            width = tmp;
        }
        WritableRaster writableRaster = CoverageUtilities.createDoubleWritableRaster(width, height, null, null, null);
        WritableRandomIter disckRandomIter = RandomIterFactory.createWritable((WritableRaster)writableRaster, null);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrixIsRowCol) {
                    disckRandomIter.setSample(x, y, 0, matrix[y][x]);
                    continue;
                }
                disckRandomIter.setSample(x, y, 0, matrix[x][y]);
            }
        }
        disckRandomIter.done();
        return writableRaster;
    }

    public static WritableRaster createWritableRasterFromMatrix(float[][] matrix, boolean matrixIsRowCol) {
        int height = matrix.length;
        int width = matrix[0].length;
        if (!matrixIsRowCol) {
            int tmp = height;
            height = width;
            width = tmp;
        }
        WritableRaster writableRaster = CoverageUtilities.createDoubleWritableRaster(width, height, null, null, null);
        WritableRandomIter disckRandomIter = RandomIterFactory.createWritable((WritableRaster)writableRaster, null);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrixIsRowCol) {
                    disckRandomIter.setSample(x, y, 0, matrix[y][x]);
                    continue;
                }
                disckRandomIter.setSample(x, y, 0, matrix[x][y]);
            }
        }
        disckRandomIter.done();
        return writableRaster;
    }

    public static WritableRaster createWritableRasterFromArray(int width, int height, int[] pixels) {
        WritableRaster writableRaster = CoverageUtilities.createDoubleWritableRaster(width, height, null, null, null);
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double value = pixels[index];
                if (value == 0.0) {
                    value = Double.NaN;
                }
                writableRaster.setSample(x, y, 0, value);
                ++index;
            }
        }
        return writableRaster;
    }

    public static GridCoverage2D buildCoverage(String name, double[][] dataMatrix, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs, boolean matrixIsRowCol) {
        WritableRaster writableRaster = CoverageUtilities.createWritableRasterFromMatrix(dataMatrix, matrixIsRowCol);
        return CoverageUtilities.buildCoverage(name, writableRaster, envelopeParams, crs);
    }

    public static GridCoverage2D buildCoverage(String name, float[][] dataMatrix, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs, boolean matrixIsRowCol) {
        WritableRaster writableRaster = CoverageUtilities.createWritableRasterFromMatrix(dataMatrix, matrixIsRowCol);
        return CoverageUtilities.buildCoverage(name, writableRaster, envelopeParams, crs);
    }

    public static GridCoverage2D buildCoverage(String name, RenderedImage renderedImage, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs) {
        double west = envelopeParams.get(WEST);
        double south = envelopeParams.get(SOUTH);
        double east = envelopeParams.get(EAST);
        double north = envelopeParams.get(NORTH);
        Envelope2D writeEnvelope = new Envelope2D(crs, west, south, east - west, north - south);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D coverage2D = factory.create((CharSequence)name, renderedImage, (Envelope)writeEnvelope);
        return coverage2D;
    }

    public static GridCoverage2D buildCoverage(String name, WritableRaster writableRaster, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs) {
        if (writableRaster instanceof GrassLegacyWritableRaster) {
            GrassLegacyWritableRaster wRaster = (GrassLegacyWritableRaster)writableRaster;
            double west = envelopeParams.get(WEST);
            double south = envelopeParams.get(SOUTH);
            double east = envelopeParams.get(EAST);
            double north = envelopeParams.get(NORTH);
            int rows = envelopeParams.get(ROWS).intValue();
            int cols = envelopeParams.get(COLS).intValue();
            Window window = new Window(west, east, south, north, rows, cols);
            GrassLegacyGridCoverage2D coverage2D = new GrassLegacyGridCoverage2D(window, wRaster.getData(), crs);
            return coverage2D;
        }
        double west = envelopeParams.get(WEST);
        double south = envelopeParams.get(SOUTH);
        double east = envelopeParams.get(EAST);
        double north = envelopeParams.get(NORTH);
        Envelope2D writeEnvelope = new Envelope2D(crs, west, south, east - west, north - south);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D coverage2D = factory.create((CharSequence)name, writableRaster, (Envelope)writeEnvelope);
        return coverage2D;
    }

    public static GridCoverage2D buildDummyCoverage() {
        HashMap<String, Double> envelopeParams = new HashMap<String, Double>();
        envelopeParams.put(NORTH, 1.0);
        envelopeParams.put(SOUTH, 0.0);
        envelopeParams.put(WEST, 0.0);
        envelopeParams.put(EAST, 1.0);
        envelopeParams.put(XRES, 1.0);
        envelopeParams.put(YRES, 1.0);
        envelopeParams.put(ROWS, 1.0);
        envelopeParams.put(COLS, 1.0);
        double[][] dataMatrix = new double[1][1];
        dataMatrix[0][0] = 0.0;
        WritableRaster writableRaster = CoverageUtilities.createWritableRasterFromMatrix(dataMatrix, true);
        return CoverageUtilities.buildCoverage("dummy", writableRaster, envelopeParams, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public static WritableRaster renderedImage2WritableRaster(RenderedImage renderedImage, boolean nullBorders) {
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        Raster data = renderedImage.getData();
        WritableRaster writableRaster = data.createCompatibleWritableRaster();
        writableRaster.setDataElements(0, 0, data);
        if (nullBorders) {
            for (int c = 0; c < width; ++c) {
                writableRaster.setSample(c, 0, 0, Double.NaN);
                writableRaster.setSample(c, height - 1, 0, Double.NaN);
            }
            for (int r = 0; r < height; ++r) {
                writableRaster.setSample(0, r, 0, Double.NaN);
                writableRaster.setSample(width - 1, r, 0, Double.NaN);
            }
        }
        return writableRaster;
    }

    public static double[] renderedImage2DoubleArray(RenderedImage renderedImage) {
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        double[] values = new double[width * height];
        RandomIter imageIter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int index = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double sample = imageIter.getSampleDouble(x, y, 0);
                values[index++] = sample;
            }
        }
        imageIter.done();
        return values;
    }

    public static int[] renderedImage2IntegerArray(RenderedImage renderedImage, double multiply) {
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        int[] values = new int[width * height];
        RandomIter imageIter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int index = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double sample = imageIter.getSampleDouble(x, y, 0);
                values[index++] = (int)(sample *= multiply);
            }
        }
        imageIter.done();
        return values;
    }

    public static WritableRaster integerArray2WritableRaster(int[] array, double divide, int width, int height) {
        WritableRaster writableRaster = CoverageUtilities.createDoubleWritableRaster(width, height, null, null, null);
        int index = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double value = (double)array[index++] / divide;
                writableRaster.setSample(x, y, 0, value);
            }
        }
        return writableRaster;
    }

    public static WritableRaster doubleArray2WritableRaster(double[] array, int width, int height) {
        WritableRaster writableRaster = CoverageUtilities.createDoubleWritableRaster(width, height, null, null, null);
        int index = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                writableRaster.setSample(x, y, 0, array[index++]);
            }
        }
        return writableRaster;
    }

    public static void setNovalueBorder(WritableRaster raster) {
        int width = raster.getWidth();
        int height = raster.getHeight();
        for (int c = 0; c < width; ++c) {
            raster.setSample(c, 0, 0, Double.NaN);
            raster.setSample(c, height - 1, 0, Double.NaN);
        }
        for (int r = 0; r < height; ++r) {
            raster.setSample(0, r, 0, Double.NaN);
            raster.setSample(width - 1, r, 0, Double.NaN);
        }
    }

    public static List<ProfilePoint> doProfile(GridCoverage2D coverage, Coordinate ... coordinates) throws Exception {
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(coverage);
        double xres = regionMap.getXres();
        double yres = regionMap.getYres();
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        double step = Math.min(xres, yres);
        GridGeometry2D gridGeometry = coverage.getGridGeometry();
        RenderedImage renderedImage = coverage.getRenderedImage();
        RandomIter iter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        Envelope2D envelope2d = gridGeometry.getEnvelope2D();
        ArrayList<ProfilePoint> profilePointsList = new ArrayList<ProfilePoint>();
        LineString line = GeometryUtilities.gf().createLineString(coordinates);
        double lineLength = line.getLength();
        LengthIndexedLine indexedLine = new LengthIndexedLine((Geometry)line);
        for (double progressive = 0.0; progressive < lineLength + step; progressive += step) {
            Coordinate c = indexedLine.extractPoint(progressive);
            GridCoordinates2D gridCoords = gridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(c.x, c.y));
            double value = Double.NaN;
            if (envelope2d.contains(c.x, c.y) && CoverageUtilities.isInside(cols, rows, gridCoords)) {
                value = iter.getSampleDouble(gridCoords.x, gridCoords.y, 0);
            }
            ProfilePoint profilePoint = new ProfilePoint(progressive, value, c.x, c.y);
            profilePointsList.add(profilePoint);
        }
        iter.done();
        return profilePointsList;
    }

    private static boolean isInside(int cols, int rows, GridCoordinates2D gridCoords) {
        return gridCoords.x >= 0 && gridCoords.x <= cols && gridCoords.y >= 0 && gridCoords.y <= rows;
    }

    public static Point2D gridToWorld(GridGeometry2D gridGeometry, int x, int y) throws InvalidGridGeometryException, TransformException {
        Point2D.Double worldPosition = new Point2D.Double(x, y);
        gridGeometry.getGridToCRS2D().transform((Point2D)worldPosition, (Point2D)worldPosition);
        return worldPosition;
    }

    public static WritableRaster replaceNovalue(RenderedImage renderedImage, double newValue) {
        WritableRaster tmpWR = (WritableRaster)renderedImage.getData();
        RandomIter pitTmpIterator = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int height = renderedImage.getHeight();
        int width = renderedImage.getWidth();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (!JGTConstants.isNovalue(pitTmpIterator.getSampleDouble(x, y, 0))) continue;
                tmpWR.setSample(x, y, 0, newValue);
            }
        }
        pitTmpIterator.done();
        return tmpWR;
    }

    public static ROI prepareROI(Geometry roi, AffineTransform mt2d) throws Exception {
        Geometry rasterSpaceGeometry = JTS.transform((Geometry)roi, (MathTransform)new AffineTransform2D(mt2d.createInverse()));
        Geometry simplifiedGeometry = DouglasPeuckerSimplifier.simplify((Geometry)rasterSpaceGeometry, (double)1.0);
        return new ROIShape((Shape)((Object)new FastLiteShape(simplifiedGeometry)));
    }

    public static double[] getMinMaxMeanSdevCount(GridCoverage2D coverage) {
        double[] minMaxMeanSdevCount = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0, 0.0, 0.0};
        RandomIter coverageIter = CoverageUtilities.getRandomIterator(coverage);
        RenderedImage coverageRI = coverage.getRenderedImage();
        int cellCount = 0;
        double sum = 0.0;
        double sumSquare = 0.0;
        for (int i = 0; i < coverageRI.getWidth(); ++i) {
            for (int j = 0; j < coverageRI.getHeight(); ++j) {
                double value = coverageIter.getSampleDouble(i, j, 0);
                if (JGTConstants.isNovalue(value)) continue;
                if (value < minMaxMeanSdevCount[0]) {
                    minMaxMeanSdevCount[0] = value;
                }
                if (value > minMaxMeanSdevCount[1]) {
                    minMaxMeanSdevCount[1] = value;
                }
                ++cellCount;
                sumSquare = (sum += value) + value * value;
            }
        }
        minMaxMeanSdevCount[2] = sum / (double)cellCount;
        minMaxMeanSdevCount[3] = Math.sqrt(sumSquare / (double)cellCount - minMaxMeanSdevCount[2] * minMaxMeanSdevCount[2]);
        minMaxMeanSdevCount[4] = cellCount;
        return minMaxMeanSdevCount;
    }

    public static boolean isGrass(String path) {
        File file = new File(path);
        File cellFolderFile = file.getParentFile();
        File mapsetFile = cellFolderFile.getParentFile();
        File windFile = new File(mapsetFile, "WIND");
        return cellFolderFile.getName().toLowerCase().equals("cell") && windFile.exists();
    }

    public static int[] colRowFromCoordinate(Coordinate coordinate, GridGeometry2D gridGeometry, Point point) {
        try {
            DirectPosition2D pos = new DirectPosition2D(coordinate.x, coordinate.y);
            GridCoordinates2D worldToGrid = gridGeometry.worldToGrid((DirectPosition)pos);
            if (point != null) {
                point.x = worldToGrid.x;
                point.y = worldToGrid.y;
            }
            return new int[]{worldToGrid.x, worldToGrid.y};
        }
        catch (InvalidGridGeometryException e) {
            e.printStackTrace();
        }
        catch (TransformException e) {
            e.printStackTrace();
        }
        point.x = Integer.MAX_VALUE;
        point.y = Integer.MAX_VALUE;
        return null;
    }

    public static Coordinate coordinateFromColRow(int col, int row, GridGeometry2D gridGeometry) {
        try {
            GridCoordinates2D pos = new GridCoordinates2D(col, row);
            DirectPosition gridToWorld = gridGeometry.gridToWorld(pos);
            double[] coord = gridToWorld.getCoordinate();
            return new Coordinate(coord[0], coord[1]);
        }
        catch (InvalidGridGeometryException e) {
            e.printStackTrace();
        }
        catch (TransformException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static GridCoverage2D coverageValuesMapper(GridCoverage2D valuesMap, GridCoverage2D maskMap) {
        RegionMap valuesRegionMap = CoverageUtilities.getRegionParamsFromGridCoverage(valuesMap);
        int cs = valuesRegionMap.getCols();
        int rs = valuesRegionMap.getRows();
        RegionMap maskRegionMap = CoverageUtilities.getRegionParamsFromGridCoverage(maskMap);
        int tmpcs = maskRegionMap.getCols();
        int tmprs = maskRegionMap.getRows();
        if (cs != tmpcs || rs != tmprs) {
            throw new IllegalArgumentException("The raster maps have to be of equal size to be mapped.");
        }
        RandomIter valuesIter = RandomIterFactory.create((RenderedImage)valuesMap.getRenderedImage(), null);
        RandomIter maskIter = RandomIterFactory.create((RenderedImage)maskMap.getRenderedImage(), null);
        WritableRaster writableRaster = CoverageUtilities.createDoubleWritableRaster(cs, rs, null, null, Double.NaN);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)writableRaster, null);
        for (int c = 0; c < cs; ++c) {
            for (int r = 0; r < rs; ++r) {
                double value;
                if (JGTConstants.isNovalue(maskIter.getSampleDouble(c, r, 0)) || JGTConstants.isNovalue(value = valuesIter.getSampleDouble(c, r, 0))) continue;
                outIter.setSample(c, r, 0, value);
            }
        }
        GridCoverage2D outCoverage = CoverageUtilities.buildCoverage("mapped", writableRaster, (HashMap<String, Double>)maskRegionMap, valuesMap.getCoordinateReferenceSystem());
        return outCoverage;
    }
}

