/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.PrintStream;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.geotools.coverage.grid.GridCoverage2D;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;

public class PrintUtilities {
    private static String separator = " ";
    private static PrintStream printer = System.out;

    public static void printCoverageData(GridCoverage2D coverage) {
        RenderedImage renderedImage = coverage.getRenderedImage();
        RandomIter renderedImageIterator = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int[] colsRows = CoverageUtilities.getRegionColsRows(coverage);
        for (int c = 0; c < colsRows[0]; ++c) {
            for (int r = 0; r < colsRows[1]; ++r) {
                printer.print(renderedImageIterator.getSampleDouble(c, r, 0));
                printer.print(separator);
            }
            printer.println();
        }
    }

    public static void printRenderedImageData(RenderedImage renderedImage) {
        RandomIter netIter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int cols = renderedImage.getWidth();
        int rows = renderedImage.getHeight();
        for (int c = 0; c < cols; ++c) {
            for (int r = 0; r < rows; ++r) {
                printer.print(netIter.getSampleDouble(c, r, 0));
                printer.print(separator);
            }
            printer.println();
        }
    }

    public static void printWritableRasterData(WritableRaster writableRaster) {
        RandomIter netIter = RandomIterFactory.create((Raster)writableRaster, null);
        int cols = writableRaster.getWidth();
        int rows = writableRaster.getHeight();
        for (int c = 0; c < cols; ++c) {
            for (int r = 0; r < rows; ++r) {
                printer.print(netIter.getSampleDouble(c, r, 0));
                printer.print(separator);
            }
            printer.println();
        }
    }

    public static void printMatrixData(double[][] matrix) {
        int cols = matrix[0].length;
        int rows = matrix.length;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                printer.print(matrix[r][c]);
                printer.print(separator);
            }
            printer.println();
        }
    }
}

