/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.jgrasstools.gears.libs.exceptions.ModelsIOException;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class CrsUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProjectionFile(String filePath, String extention, CoordinateReferenceSystem crs) throws IOException {
        String prjPath = null;
        if (extention != null && filePath.toLowerCase().endsWith("." + extention)) {
            int dotLoc = filePath.lastIndexOf(".");
            prjPath = filePath.substring(0, dotLoc);
            prjPath = prjPath + ".prj";
        } else {
            prjPath = filePath + ".prj";
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(prjPath));
            bufferedWriter.write(crs.toWKT());
        }
        finally {
            bufferedWriter.close();
        }
    }

    public static CoordinateReferenceSystem readProjectionFile(String filePath, String extention) throws Exception {
        CoordinateReferenceSystem crs = null;
        String prjPath = null;
        if (extention != null && filePath.toLowerCase().endsWith("." + extention)) {
            int dotLoc = filePath.lastIndexOf(".");
            prjPath = filePath.substring(0, dotLoc);
            prjPath = prjPath + ".prj";
        } else {
            prjPath = filePath + ".prj";
        }
        File prjFile = new File(prjPath);
        if (!prjFile.exists()) {
            throw new ModelsIOException("The prj file doesn't exist: " + prjPath, "CRSUTILITIES");
        }
        try {
            String wkt = FileUtilities.readFile(prjFile);
            crs = CRS.parseWKT((String)wkt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crs;
    }

    public static void reproject(CoordinateReferenceSystem from, CoordinateReferenceSystem to, Object[] geometries) throws Exception {
        MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)from, (CoordinateReferenceSystem)to);
        for (int i = 0; i < geometries.length; ++i) {
            geometries[i] = JTS.transform((Geometry)((Geometry)geometries[i]), (MathTransform)mathTransform);
        }
    }

    public static void reproject(CoordinateReferenceSystem from, CoordinateReferenceSystem to, Coordinate[] coordinates) throws Exception {
        MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)from, (CoordinateReferenceSystem)to);
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = JTS.transform((Coordinate)coordinates[i], (Coordinate)coordinates[i], (MathTransform)mathTransform);
        }
    }

    public static String getCodeFromCrs(CoordinateReferenceSystem crs) throws Exception {
        String code = null;
        try {
            Integer epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
            code = "EPSG:" + epsg;
        }
        catch (Exception e) {
            code = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true);
        }
        return code;
    }
}

