/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class CompressionUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFolder(String srcFolder, String destZipFile, boolean addBaseFolder) throws IOException {
        if (new File(srcFolder).isDirectory()) {
            DeflaterOutputStream zip = null;
            FileOutputStream fileWriter = null;
            try {
                fileWriter = new FileOutputStream(destZipFile);
                zip = new ZipOutputStream(fileWriter);
                CompressionUtilities.addFolderToZip("", srcFolder, (ZipOutputStream)zip, addBaseFolder);
            }
            finally {
                if (zip != null) {
                    zip.flush();
                    ((ZipOutputStream)zip).close();
                }
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
        } else {
            throw new IOException(srcFolder + " is not a folder.");
        }
    }

    public static void unzipFolder(String zipFile, String destFolder) throws IOException {
        ZipFile zf = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> zipEnum = zf.entries();
        String dir = destFolder;
        while (zipEnum.hasMoreElements()) {
            ZipEntry item = zipEnum.nextElement();
            if (item.isDirectory()) {
                File newdir = new File(dir + File.separator + item.getName());
                if (newdir.mkdir()) continue;
                throw new IOException();
            }
            String newfilePath = dir + File.separator + item.getName();
            File newFile = new File(newfilePath);
            if (!newFile.getParentFile().exists() && !newFile.getParentFile().mkdirs()) {
                throw new IOException();
            }
            InputStream is = zf.getInputStream(item);
            FileOutputStream fos = new FileOutputStream(newfilePath);
            byte[] buffer = new byte[512];
            int readchars = 0;
            while ((readchars = is.read(buffer)) != -1) {
                fos.write(buffer, 0, readchars);
            }
            is.close();
            fos.close();
        }
        zf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToZip(String path, String srcFile, ZipOutputStream zip) throws IOException {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            CompressionUtilities.addFolderToZip(path, srcFile, zip, true);
        } else {
            byte[] buf = new byte[1024];
            FileInputStream in = null;
            try {
                int len;
                in = new FileInputStream(srcFile);
                zip.putNextEntry(new ZipEntry(path + File.separator + folder.getName()));
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip, boolean addFolder) throws IOException {
        File folder = new File(srcFolder);
        String[] listOfFiles = folder.list();
        for (int i = 0; i < listOfFiles.length; ++i) {
            String folderPath = null;
            folderPath = path.length() < 1 ? folder.getName() : path + File.separator + folder.getName();
            String srcFile = srcFolder + File.separator + listOfFiles[i];
            CompressionUtilities.addToZip(folderPath, srcFile, zip);
        }
    }
}

