/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.ui;

import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.RenderedImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.License;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.swing.JMapFrame;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ColorMap;

@Description(value="Utility class for viewing coverages.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Coverage, Raster, Viewer, UI")
@Status(value=40)
@UI(value="hide")
@License(value="General Public License Version 3 (GPLv3)")
public class CoverageViewer {
    @Description(value="The coverage to visualize.")
    @In
    public GridCoverage2D raster = null;
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);

    @Execute
    public void viewCoverage() throws Exception {
        StyleBuilder sB = new StyleBuilder(this.sf);
        RasterSymbolizer rasterSym = this.sf.createRasterSymbolizer();
        org.geotools.styling.ColorMap colorMap = this.sf.createColorMap();
        RenderedImage renderedImage = this.raster.getRenderedImage();
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.POSITIVE_INFINITY;
        RectIter iter = RectIterFactory.create((RenderedImage)renderedImage, null);
        while (true) {
            double value;
            if ((value = iter.getSampleDouble()) > max) {
                max = value;
            }
            if (value < min) {
                min = value;
            }
            if (!iter.nextPixelDone()) continue;
            iter.startPixels();
            if (iter.nextLineDone()) break;
        }
        Color fromColor = Color.blue;
        Color toColor = Color.red;
        Expression fromColorExpr = sB.colorExpression(new Color(fromColor.getRed(), fromColor.getGreen(), fromColor.getBlue(), 255));
        Expression toColorExpr = sB.colorExpression(new Color(toColor.getRed(), toColor.getGreen(), toColor.getBlue(), 255));
        Expression fromExpr = sB.literalExpression(min);
        Expression toExpr = sB.literalExpression(max);
        ColorMapEntry entry = this.sf.createColorMapEntry();
        entry.setQuantity(fromExpr);
        entry.setColor(fromColorExpr);
        colorMap.addColorMapEntry(entry);
        entry = this.sf.createColorMapEntry();
        entry.setQuantity(toExpr);
        entry.setColor(toColorExpr);
        colorMap.addColorMapEntry(entry);
        rasterSym.setColorMap((ColorMap)colorMap);
        Style rasterStyle = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{rasterSym});
        DefaultMapContext map = new DefaultMapContext();
        map.setTitle("Coverage Viewer");
        map.addLayer((GridCoverage)this.raster, rasterStyle);
        final JMapFrame frame = new JMapFrame((MapContext)map);
        frame.setSize(800, 600);
        frame.enableStatusBar(true);
        frame.enableTool(new JMapFrame.Tool[]{JMapFrame.Tool.ZOOM, JMapFrame.Tool.PAN, JMapFrame.Tool.RESET});
        frame.enableToolBar(true);
        frame.setVisible(true);
        frame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.setVisible(false);
            }
        });
        while (frame.isVisible()) {
            Thread.sleep(300L);
        }
    }
}

