/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectortransformer;

import com.vividsolutions.jts.geom.Geometry;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollections;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.utils.features.FeatureGeometrySubstitutor;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.operation.MathTransform;

@Description(value="Module for vector tranforms. Currently only translation is supported.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Transform, Vector")
@Label(value="Vector Processing")
@Status(value=40)
@Name(value="vtrans")
@License(value="General Public License Version 3 (GPLv3)")
public class VectorTransformer
extends JGTModel {
    @Description(value="The feature collection that has to be transformed.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The translation along the X axis.")
    @In
    public double pTransX;
    @Description(value="The translation along the Y axis.")
    @In
    public double pTransY;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The reprojected feature collection.")
    @Out
    public SimpleFeatureCollection outVector = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.outVector = FeatureCollections.newCollection();
        SimpleFeatureType featureType = (SimpleFeatureType)this.inVector.getSchema();
        FeatureGeometrySubstitutor substitutor = new FeatureGeometrySubstitutor(featureType);
        SimpleFeatureIterator inFeatureIterator = this.inVector.features();
        boolean id = false;
        this.pm.beginTask("Transforming geometries...", this.inVector.size());
        while (inFeatureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)inFeatureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            AffineTransform2D transform = new AffineTransform2D(1.0, 0.0, 0.0, 1.0, this.pTransX, this.pTransY);
            Geometry transformedGeometry = JTS.transform((Geometry)geometry, (MathTransform)transform);
            SimpleFeature newFeature = substitutor.substituteGeometry(feature, transformedGeometry);
            this.outVector.add((Feature)newFeature);
            this.pm.worked(1);
        }
        inFeatureIterator.close();
        this.pm.done();
    }
}

