/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectorreshaper;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.exceptions.ModelsRuntimeException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module to reshape a vector.")
@Documentation(value="VectorReshaper.html")
@Author(name="Andrea Antonello, Jody Garnett", contact="http://www.hydrologis.com")
@Keywords(value="Reshape, Vector, VectorFilter")
@Status(value=40)
@Label(value="Vector Processing")
@Name(value="reshape")
@License(value="General Public License Version 3 (GPLv3)")
public class VectorReshaper
extends JGTModel {
    @Description(value="The vector to reshape.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The ECQL reshape function.")
    @In
    public String pCql = null;
    @Description(value="The list of fields to remove, comma separated.")
    @In
    public String pRemove = null;
    @Description(value="The new reshaped vector.")
    @Out
    public SimpleFeatureCollection outVector;
    private SimpleFeature sample = null;
    static int count = 0;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.checkNull(this.inVector);
        ArrayList<String> removeNames = new ArrayList<String>();
        if (this.pRemove != null) {
            String[] split;
            for (String string : split = this.pRemove.split(",")) {
                removeNames.add(string.trim());
            }
        }
        SimpleFeatureType originalFeatureType = (SimpleFeatureType)this.inVector.getSchema();
        List attributeDescriptors = originalFeatureType.getAttributeDescriptors();
        StringBuilder sB = new StringBuilder();
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            String name = attributeDescriptor.getLocalName();
            if (removeNames.contains(name.trim())) continue;
            sB.append(name);
            sB.append("=");
            sB.append(name);
            sB.append("\n");
        }
        if (this.pCql != null && this.pCql.length() > 0) {
            sB.append(this.pCql);
        }
        this.sample = this.getSample();
        String expressionString = sB.toString();
        List<String> names = this.createNameList(expressionString);
        final List<Expression> expressions = this.createExpressionList(expressionString);
        SimpleFeatureType newFeatureType = this.createFeatureType(expressionString, originalFeatureType, names, expressions);
        this.outVector = FeatureCollections.newCollection();
        final SimpleFeatureBuilder build = new SimpleFeatureBuilder(newFeatureType);
        this.inVector.accepts(new FeatureVisitor(){

            public void visit(Feature rawFeature) {
                SimpleFeature feature = (SimpleFeature)rawFeature;
                for (int i = 0; i < expressions.size(); ++i) {
                    build.add(((Expression)expressions.get(i)).evaluate((Object)feature));
                }
                SimpleFeature created = build.buildFeature(feature.getID());
                VectorReshaper.this.outVector.add((Feature)created);
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleFeature getSample() {
        SimpleFeatureIterator iterator = this.inVector.features();
        try {
            if (!iterator.hasNext()) {
                throw new ModelsRuntimeException("Input featurecollection is empty.", this.getClass().getSimpleName());
            }
            SimpleFeature simpleFeature = (SimpleFeature)iterator.next();
            return simpleFeature;
        }
        finally {
            iterator.close();
        }
    }

    private SimpleFeatureType createFeatureType(String expressionString, SimpleFeatureType originalFeatureType, List<String> names, List<Expression> expressions) throws SchemaException {
        SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            Expression expression = expressions.get(i);
            Object value = expression.evaluate((Object)this.sample);
            Class<?> binding = null;
            if (value == null) {
                if (expression instanceof PropertyName) {
                    String path = ((PropertyName)expression).getPropertyName();
                    AttributeType attributeType = this.sample.getFeatureType().getType(path);
                    if (attributeType == null) {
                        throw new ModelsIllegalargumentException("Attribute type is null", this.getClass().getSimpleName());
                    }
                    binding = attributeType.getClass();
                }
            } else {
                binding = value.getClass();
            }
            if (binding == null) {
                throw new ModelsIllegalargumentException("Binding is null", this.getClass().getSimpleName());
            }
            if (Geometry.class.isAssignableFrom(binding)) {
                AttributeType originalAttributeType = originalFeatureType.getType(name);
                CoordinateReferenceSystem crs = originalAttributeType instanceof GeometryType ? ((GeometryType)originalAttributeType).getCoordinateReferenceSystem() : originalFeatureType.getCoordinateReferenceSystem();
                build.crs(crs);
                build.add(name, binding);
                continue;
            }
            build.add(name, binding);
        }
        build.setName(this.getNewTypeName(originalFeatureType.getTypeName()));
        return build.buildFeatureType();
    }

    private List<String> createNameList(String expressionString) {
        ArrayList<String> list = new ArrayList<String>();
        String definition = expressionString.replaceAll("\r", "\n").replaceAll("[\n\r][\n\r]", "\n");
        for (String line : definition.split("\n")) {
            int mark = line.indexOf("=");
            if (mark == -1) continue;
            String name = line.substring(0, mark).trim();
            if (list.contains(name)) {
                System.out.println("Name already existing");
                continue;
            }
            list.add(name);
        }
        return list;
    }

    private List<Expression> createExpressionList(String expressionString) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        String definition = expressionString.replaceAll("\r", "\n").replaceAll("[\n\r][\n\r]", "\n");
        for (String line : definition.split("\n")) {
            Expression expression;
            int mark = line.indexOf("=");
            if (mark == -1) continue;
            String expressionDefinition = line.substring(mark + 1).trim();
            try {
                expression = CQL.toExpression((String)expressionDefinition);
            }
            catch (CQLException e) {
                throw new ModelsRuntimeException(e.toString(), this);
            }
            list.add(expression);
        }
        return list;
    }

    public String getNewTypeName(String typeName) {
        return typeName + count++;
    }
}

