/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectorreprojector;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.CRS;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module for vector reprojection.")
@Documentation(value="VectorReprojector.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="CRS, Reprojection, Vector")
@Label(value="Vector Processing")
@Status(value=40)
@Name(value="vreproject")
@License(value="General Public License Version 3 (GPLv3)")
public class VectorReprojector
extends JGTModel {
    @Description(value="The vector that has to be reprojected.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The code defining the target coordinate reference system, composed by authority and code number (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="A flag to modify the axes order.")
    @In
    public Boolean doLongitudeFirst = null;
    @Description(value="A coordinate reference system on which to force the input, composed by authority and code number (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pForceCode;
    @Description(value="Switch that set to true allows for some error due to different datums. If set to false, it won't reproject without Bursa Wolf parameters.")
    @In
    public boolean doLenient = true;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The output reprojected vector.")
    @Out
    public SimpleFeatureCollection outVector = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        CoordinateReferenceSystem targetCrs = null;
        targetCrs = this.doLongitudeFirst != null ? CRS.decode((String)this.pCode, (boolean)this.doLongitudeFirst) : CRS.decode((String)this.pCode);
        if (this.pForceCode != null) {
            this.pm.beginTask("Forcing input crs...", -1);
            CoordinateReferenceSystem forcedCrs = CRS.decode((String)this.pForceCode);
            this.inVector = new ForceCoordinateSystemFeatureResults((FeatureCollection)this.inVector, forcedCrs);
            this.pm.done();
        }
        this.pm.beginTask("Reprojecting features...", -1);
        try {
            this.outVector = new ReprojectingFeatureCollection(this.inVector, targetCrs);
        }
        finally {
            this.pm.done();
        }
    }
}

