/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectormerger;

import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollections;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.utils.features.FeatureExtender;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Module for merging vecotrs into one single.")
@Documentation(value="VectorMerger.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Feature, Vector, Merge")
@Label(value="Vector Processing")
@Status(value=40)
@Name(value="vmerge")
@License(value="General Public License Version 3 (GPLv3)")
public class VectorMerger
extends JGTModel {
    @Description(value="The input vectors to be merged.")
    @In
    public List<SimpleFeatureCollection> inVectors;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The output vector.")
    @Out
    public SimpleFeatureCollection outVector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkNull(this.inVectors);
        SimpleFeatureType firstType = null;
        FeatureExtender fEx = null;
        this.pm.beginTask("Merging features...", this.inVectors.size());
        try {
            this.outVector = FeatureCollections.newCollection();
            for (SimpleFeatureCollection featureCollection : this.inVectors) {
                if (firstType == null) {
                    firstType = (SimpleFeatureType)featureCollection.getSchema();
                    fEx = new FeatureExtender(firstType, new String[0], new Class[0]);
                } else {
                    SimpleFeatureType schema = (SimpleFeatureType)featureCollection.getSchema();
                    int compare = DataUtilities.compare((SimpleFeatureType)firstType, (SimpleFeatureType)schema);
                    if (compare != 0) {
                        throw new ModelsIllegalargumentException("Merging is done only on same feature types.", this);
                    }
                }
                SimpleFeatureIterator featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature f = (SimpleFeature)featureIterator.next();
                    SimpleFeature extendFeature = fEx.extendFeature(f, new Object[0]);
                    this.outVector.add((Feature)extendFeature);
                }
                this.pm.worked(1);
            }
        }
        finally {
            this.pm.done();
        }
    }
}

