/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectorfilter;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollections;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.utils.features.FilterUtilities;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

@Description(value="Module that creates a subset of a vector based on a filtered vector.")
@Documentation(value="VectorFilter.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Filter, Vector, VectorReshaper")
@Label(value="Vector Processing")
@Status(value=40)
@Name(value="vfilter")
@License(value="General Public License Version 3 (GPLv3)")
public class VectorFilter
extends JGTModel {
    @Description(value="The vector to filter.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The ECQL filter function.")
    @In
    public String pCql = null;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The filtered vector.")
    @Out
    public SimpleFeatureCollection outVector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.checkNull(this.inVector, this.pCql);
        Filter cqlFilter = FilterUtilities.getCQLFilter(this.pCql);
        SimpleFeatureCollection subCollection = this.inVector.subCollection(cqlFilter);
        this.outVector = FeatureCollections.newCollection();
        SimpleFeatureIterator iterator = subCollection.features();
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                this.outVector.add((Feature)feature);
            }
        }
        finally {
            iterator.close();
        }
    }
}

